/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.crafting.recipe;

import com.github.elenterius.biomancy.BiomancyMod;
import com.github.elenterius.biomancy.crafting.recipe.AnyFoodIngredient;
import com.github.elenterius.biomancy.crafting.recipe.DigestingRecipe;
import com.github.elenterius.biomancy.crafting.recipe.DynamicProcessingRecipe;
import com.github.elenterius.biomancy.init.ModItems;
import com.github.elenterius.biomancy.init.ModRecipes;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class FoodDigestingRecipe
extends DynamicProcessingRecipe
implements DigestingRecipe {
    private final int multiplier;
    private final ItemStack resultBaseItem;
    private final AnyFoodIngredient ingredient;
    private final NonNullList<Ingredient> ingredients;

    protected FoodDigestingRecipe(ResourceLocation key, int multiplier, ItemStack resultBaseItem) {
        super(key, (RecipeType)ModRecipes.DIGESTING_RECIPE_TYPE.get());
        this.multiplier = multiplier;
        this.resultBaseItem = resultBaseItem;
        this.ingredient = new AnyFoodIngredient();
        this.ingredients = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{this.ingredient});
    }

    @Override
    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.ingredients;
    }

    public static int getFoodNutrition(ItemStack stack) {
        if (stack.m_41619_()) {
            return 0;
        }
        if (!stack.m_41614_()) {
            return 0;
        }
        FoodProperties foodProperties = stack.getFoodProperties(null);
        return foodProperties != null ? foodProperties.m_38744_() : 0;
    }

    @Override
    public int getCraftingTimeTicks(Container inputInventory) {
        int nutrition = FoodDigestingRecipe.getFoodNutrition(inputInventory.m_8020_(0));
        return nutrition > 0 ? Mth.m_14165_((double)(200.0 + 190.0 * Math.log(nutrition))) : 0;
    }

    @Override
    public int getCraftingCostNutrients(Container inputInventory) {
        float sixtySecondsInTicks = 1200.0f;
        return 1 + Mth.m_14143_((float)((float)this.getCraftingTimeTicks(inputInventory) / sixtySecondsInTicks));
    }

    public boolean m_5818_(Container inputInventory, Level pLevel) {
        int nutrition = FoodDigestingRecipe.getFoodNutrition(inputInventory.m_8020_(0));
        return nutrition > 0;
    }

    public ItemStack m_5874_(Container inputInventory, RegistryAccess registryAccess) {
        int nutrition = FoodDigestingRecipe.getFoodNutrition(inputInventory.m_8020_(0));
        if (nutrition <= 0) {
            return ItemStack.f_41583_;
        }
        int count = Mth.m_14045_((int)(nutrition * this.multiplier), (int)1, (int)128);
        return this.resultBaseItem.m_255036_(count);
    }

    public boolean m_8004_(int width, int height) {
        return width * height == 1;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipes.FOOD_DIGESTING_SERIALIZER.get();
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)ModItems.DIGESTER.get());
    }

    public static class RecipeBuilder {
        public static void save(Consumer<FinishedRecipe> consumer, int multiplier, Item item) {
            RecipeBuilder.save(consumer, multiplier, new ItemStack((ItemLike)item));
        }

        public static void save(Consumer<FinishedRecipe> consumer, int multiplier, ItemStack stack) {
            ResourceLocation key = BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_());
            ResourceLocation id = BiomancyMod.createRL(key.m_135815_() + "_from_digesting_dynamic_food");
            String subFolder = ModRecipes.DIGESTING_RECIPE_TYPE.getId().m_135815_();
            RecipeBuilder.save(consumer, multiplier, stack, new ResourceLocation(id.m_135827_(), subFolder + "/" + id.m_135815_()));
        }

        public static void save(Consumer<FinishedRecipe> consumer, final int multiplier, final ItemStack stack, final ResourceLocation id) {
            consumer.accept(new FinishedRecipe(){

                public RecipeSerializer<?> m_6637_() {
                    return (RecipeSerializer)ModRecipes.FOOD_DIGESTING_SERIALIZER.get();
                }

                public void m_7917_(JsonObject json) {
                    json.addProperty("multiplier", (Number)multiplier);
                    json.add("result_base", (JsonElement)this.serialize(stack));
                }

                private JsonObject serialize(ItemStack stack2) {
                    JsonObject json = new JsonObject();
                    json.addProperty("item", BuiltInRegistries.f_257033_.m_7981_((Object)stack2.m_41720_()).toString());
                    if (stack2.m_41782_()) {
                        json.addProperty("nbt", stack2.m_41783_().m_7916_());
                    }
                    return json;
                }

                public ResourceLocation m_6445_() {
                    return id;
                }

                @Nullable
                public JsonObject m_5860_() {
                    return null;
                }

                public ResourceLocation m_6448_() {
                    return new ResourceLocation("");
                }
            });
        }
    }

    public static class Serializer
    implements RecipeSerializer<FoodDigestingRecipe> {
        public FoodDigestingRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            int multiplier = GsonHelper.m_13824_((JsonObject)json, (String)"multiplier", (int)1);
            ItemStack resultBaseItem = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result_base"));
            return new FoodDigestingRecipe(recipeId, multiplier, resultBaseItem);
        }

        @Nullable
        public FoodDigestingRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            int multiplier = buffer.m_130242_();
            ItemStack resultBaseItem = buffer.m_130267_();
            return new FoodDigestingRecipe(recipeId, multiplier, resultBaseItem);
        }

        public void toNetwork(FriendlyByteBuf buffer, FoodDigestingRecipe recipe) {
            buffer.m_130130_(recipe.multiplier);
            buffer.m_130055_(recipe.resultBaseItem);
        }
    }
}

