/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.crafting.recipe;

import com.google.gson.JsonObject;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;

public interface ItemCountRange {
    public static <T extends ItemCountRange> void toJson(JsonObject jsonObject, T range) {
        RangeSerializer<?> serializer = range.getSerializer();
        jsonObject.addProperty("type", RangeSerializerType.getType(serializer));
        serializer.toJson(jsonObject, range);
    }

    public static ItemCountRange fromJson(JsonObject jsonObject) {
        String type = GsonHelper.m_13906_((JsonObject)jsonObject, (String)"type");
        return RangeSerializerType.getSerializer(type).fromJson(jsonObject);
    }

    public static <T extends ItemCountRange> void toNetwork(FriendlyByteBuf buffer, T range) {
        RangeSerializer<?> serializer = range.getSerializer();
        buffer.writeByte((int)RangeSerializerType.getId(serializer));
        serializer.toNetwork(buffer, range);
    }

    public static ItemCountRange fromNetwork(FriendlyByteBuf buffer) {
        RangeSerializer<? extends ItemCountRange> serializer = RangeSerializerType.getSerializer(buffer.readByte());
        return serializer.fromNetwork(buffer);
    }

    public int getCount(RandomSource var1);

    public RangeSerializer<?> getSerializer();

    public static interface RangeSerializer<T extends ItemCountRange> {
        public void toJson(JsonObject var1, T var2);

        public T fromJson(JsonObject var1);

        public void toNetwork(FriendlyByteBuf var1, T var2);

        public T fromNetwork(FriendlyByteBuf var1);
    }

    public static enum RangeSerializerType {
        CONSTANT(0, "constant", ConstantValue.SERIALIZER),
        UNIFORM(1, "uniform", UniformRange.SERIALIZER),
        BINOMIAL(2, "binomial", BinomialRange.SERIALIZER);

        final byte id;
        final String type;
        final RangeSerializer<? extends ItemCountRange> serializer;

        private RangeSerializerType(int id, String type, RangeSerializer<? extends ItemCountRange> serializer) {
            this.id = (byte)id;
            this.type = type;
            this.serializer = serializer;
        }

        public byte getId() {
            return this.id;
        }

        public String getType() {
            return this.type;
        }

        public static RangeSerializer<? extends ItemCountRange> getSerializer(String type) {
            for (RangeSerializerType available : RangeSerializerType.values()) {
                if (!type.equals(available.type)) continue;
                return available.serializer;
            }
            throw new IllegalArgumentException("Invalid Type: " + type);
        }

        public static RangeSerializer<? extends ItemCountRange> getSerializer(byte id) {
            for (RangeSerializerType available : RangeSerializerType.values()) {
                if (id != available.id) continue;
                return available.serializer;
            }
            throw new IllegalArgumentException("Invalid Id: " + id);
        }

        public static String getType(RangeSerializer<? extends ItemCountRange> serializer) {
            return RangeSerializerType.get(serializer, RangeSerializerType::getType);
        }

        public static byte getId(RangeSerializer<? extends ItemCountRange> serializer) {
            return RangeSerializerType.get(serializer, RangeSerializerType::getId);
        }

        public static <T> T get(RangeSerializer<? extends ItemCountRange> serializer, Function<RangeSerializerType, T> func) {
            for (RangeSerializerType available : RangeSerializerType.values()) {
                if (serializer != available.serializer) continue;
                return func.apply(available);
            }
            throw new IllegalArgumentException("Invalid serializer: " + serializer);
        }
    }

    public record ConstantValue(int value) implements ItemCountRange
    {
        public static final Serializer SERIALIZER = new Serializer();

        @Override
        public int getCount(RandomSource rng) {
            return this.value;
        }

        public RangeSerializer<ConstantValue> getSerializer() {
            return SERIALIZER;
        }

        static class Serializer
        implements RangeSerializer<ConstantValue> {
            Serializer() {
            }

            @Override
            public void toJson(JsonObject jsonObject, ConstantValue constant) {
                jsonObject.addProperty("value", (Number)constant.value);
            }

            @Override
            public ConstantValue fromJson(JsonObject jsonObject) {
                return new ConstantValue(jsonObject.get("value").getAsInt());
            }

            @Override
            public void toNetwork(FriendlyByteBuf buffer, ConstantValue constant) {
                buffer.m_130130_(constant.value);
            }

            @Override
            public ConstantValue fromNetwork(FriendlyByteBuf buffer) {
                int constantValue = buffer.m_130242_();
                return new ConstantValue(constantValue);
            }
        }
    }

    public record BinomialRange(int n, float p) implements ItemCountRange
    {
        public static final Serializer SERIALIZER = new Serializer();

        @Override
        public int getCount(RandomSource rng) {
            int v = 0;
            for (int i = 0; i < this.n; ++i) {
                if (!(rng.m_188501_() < this.p)) continue;
                ++v;
            }
            return v;
        }

        public RangeSerializer<BinomialRange> getSerializer() {
            return SERIALIZER;
        }

        static class Serializer
        implements RangeSerializer<BinomialRange> {
            Serializer() {
            }

            @Override
            public void toJson(JsonObject jsonObject, BinomialRange range) {
                jsonObject.addProperty("n", (Number)range.n);
                jsonObject.addProperty("p", (Number)Float.valueOf(range.p));
            }

            @Override
            public BinomialRange fromJson(JsonObject jsonObject) {
                return new BinomialRange(GsonHelper.m_13927_((JsonObject)jsonObject, (String)"n"), GsonHelper.m_13915_((JsonObject)jsonObject, (String)"p"));
            }

            @Override
            public void toNetwork(FriendlyByteBuf buffer, BinomialRange range) {
                buffer.m_130130_(range.n);
                buffer.writeFloat(range.p);
            }

            @Override
            public BinomialRange fromNetwork(FriendlyByteBuf buffer) {
                int n1 = buffer.m_130242_();
                float p1 = buffer.readFloat();
                return new BinomialRange(n1, p1);
            }
        }
    }

    public record UniformRange(int min, int max) implements ItemCountRange
    {
        public static final Serializer SERIALIZER = new Serializer();

        @Override
        public int getCount(RandomSource rng) {
            return Mth.m_216271_((RandomSource)rng, (int)this.min, (int)this.max);
        }

        public RangeSerializer<UniformRange> getSerializer() {
            return SERIALIZER;
        }

        static class Serializer
        implements RangeSerializer<UniformRange> {
            Serializer() {
            }

            @Override
            public void toJson(JsonObject jsonObject, UniformRange range) {
                jsonObject.addProperty("min", (Number)range.min);
                jsonObject.addProperty("max", (Number)range.max);
            }

            @Override
            public UniformRange fromJson(JsonObject jsonObject) {
                return new UniformRange(GsonHelper.m_13927_((JsonObject)jsonObject, (String)"min"), GsonHelper.m_13927_((JsonObject)jsonObject, (String)"max"));
            }

            @Override
            public void toNetwork(FriendlyByteBuf buffer, UniformRange range) {
                buffer.m_130130_(range.min);
                buffer.m_130130_(range.max);
            }

            @Override
            public UniformRange fromNetwork(FriendlyByteBuf buffer) {
                int min1 = buffer.m_130242_();
                int max1 = buffer.m_130242_();
                return new UniformRange(min1, max1);
            }
        }
    }
}

