/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.crafting.state;

import com.github.elenterius.biomancy.crafting.recipe.ProcessingRecipe;
import com.github.elenterius.biomancy.crafting.state.CraftingState;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;

public abstract class RecipeCraftingStateData<T extends ProcessingRecipe<C>, C extends Container>
implements ContainerData {
    public static final String RECIPE_ID_KEY = "RecipeId";
    public static final String TIME_ELAPSED_KEY = "TimeElapsed";
    public static final String TIME_FOR_COMPLETION_KEY = "TimeForCompletion";
    public static final String NUTRIENTS_COST_KEY = "NutrientsCost";
    public static final int TIME_INDEX = 0;
    public static final int TIME_FOR_COMPLETION_INDEX = 1;
    public static final int NUTRIENTS_COST_INDEX = 2;
    public int timeElapsed;
    public int timeForCompletion;
    public int nutrientsCost;
    private CraftingState craftingState = CraftingState.NONE;
    private ResourceLocation recipeId;

    public CraftingState getCraftingState() {
        return this.craftingState;
    }

    public void setCraftingState(CraftingState craftingState) {
        this.craftingState = craftingState;
    }

    public boolean isCraftingCanceled() {
        return this.craftingState == CraftingState.CANCELED;
    }

    public void cancelCrafting() {
        this.clear();
        this.craftingState = CraftingState.CANCELED;
    }

    protected abstract boolean isRecipeOfInstance(Recipe<?> var1);

    public Optional<T> getCraftingGoalRecipe(Level level) {
        Recipe recipe;
        if (this.recipeId == null) {
            return Optional.empty();
        }
        RecipeManager recipeManager = level.m_7465_();
        Optional optional = recipeManager.m_44043_(this.recipeId);
        if (optional.isPresent() && this.isRecipeOfInstance(recipe = (Recipe)optional.get())) {
            return Optional.of((ProcessingRecipe)recipe);
        }
        return Optional.empty();
    }

    public void setCraftingGoalRecipe(T recipe, C inputInventory) {
        this.recipeId = recipe.m_6423_();
        this.timeForCompletion = recipe.getCraftingTimeTicks(inputInventory);
        this.nutrientsCost = recipe.getCraftingCostNutrients(inputInventory);
    }

    public abstract int getFuelCost();

    public void clear() {
        this.recipeId = null;
        this.timeElapsed = 0;
        this.timeForCompletion = 0;
        this.nutrientsCost = 0;
    }

    public void serialize(CompoundTag tag) {
        CraftingState.toNBT(tag, this.craftingState);
        if (this.recipeId != null) {
            tag.m_128359_(RECIPE_ID_KEY, this.recipeId.toString());
        }
        tag.m_128405_(TIME_ELAPSED_KEY, this.timeElapsed);
        tag.m_128405_(TIME_FOR_COMPLETION_KEY, this.timeForCompletion);
        tag.m_128405_(NUTRIENTS_COST_KEY, this.nutrientsCost);
    }

    public void deserialize(CompoundTag tag) {
        this.craftingState = CraftingState.fromNBT(tag);
        if (tag.m_128441_(RECIPE_ID_KEY)) {
            String id = tag.m_128461_(RECIPE_ID_KEY);
            this.recipeId = ResourceLocation.m_135820_((String)id);
        } else {
            this.recipeId = null;
        }
        this.timeElapsed = tag.m_128451_(TIME_ELAPSED_KEY);
        this.timeForCompletion = tag.m_128451_(TIME_FOR_COMPLETION_KEY);
        this.nutrientsCost = tag.m_128451_(NUTRIENTS_COST_KEY);
    }

    protected void validateIndex(int index) {
        if (index < 0 || index >= this.m_6499_()) {
            throw new IndexOutOfBoundsException("Index out of bounds:" + index);
        }
    }

    public int m_6413_(int index) {
        this.validateIndex(index);
        if (index == 0) {
            return this.timeElapsed;
        }
        if (index == 1) {
            return this.timeForCompletion;
        }
        if (index == 2) {
            return this.nutrientsCost;
        }
        return 0;
    }

    public void m_8050_(int index, int value) {
        this.validateIndex(index);
        if (index == 0) {
            this.timeElapsed = value;
        } else if (index == 1) {
            this.timeForCompletion = value;
        } else if (index == 2) {
            this.nutrientsCost = value;
        }
    }

    public int m_6499_() {
        return 3;
    }
}

