/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.entity.mob;

import com.github.elenterius.biomancy.entity.mob.OwnablePathfinderMob;
import com.github.elenterius.biomancy.util.CombatUtil;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.Ocelot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

@Deprecated
public class Boomling
extends OwnablePathfinderMob
implements GeoEntity {
    private static final EntityDataAccessor<Byte> CLIMBING = SynchedEntityData.m_135353_(Boomling.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Byte> STATE = SynchedEntityData.m_135353_(Boomling.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Integer> COLOR = SynchedEntityData.m_135353_(Boomling.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final double MAX_TRIGGER_DIST_SQ = 12.25;
    private int prevFuseTimer;
    private int fuseTimer;
    private short maxFuseTimer = (short)22;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public Boomling(EntityType<? extends Boomling> entityType, Level level) {
        super(entityType, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22277_, 7.5).m_22268_(Attributes.f_22276_, 6.5).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22281_, 1.0);
    }

    public static void spawnEffectAOE(Level world, @Nullable LivingEntity attacker, Vec3 pos, Potion potion, Collection<MobEffectInstance> effects, int color) {
        AreaEffectCloud aoeCloud = new AreaEffectCloud(world, pos.f_82479_, pos.f_82480_, pos.f_82481_);
        aoeCloud.m_19718_(attacker);
        aoeCloud.m_19712_(3.0f);
        aoeCloud.m_19732_(-0.5f);
        aoeCloud.m_19740_(10);
        aoeCloud.m_19738_(-aoeCloud.m_19743_() / (float)aoeCloud.m_19748_());
        aoeCloud.m_19714_(color);
        aoeCloud.m_19722_(potion);
        for (MobEffectInstance effect : effects) {
            aoeCloud.m_19716_(new MobEffectInstance(effect));
        }
        world.m_7967_((Entity)aoeCloud);
        int event = potion.m_43491_() ? 2002 : 2007;
        world.m_46796_(event, BlockPos.m_274446_((Position)pos), color);
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new ExplodeGoal());
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Ocelot.class, 6.0f, 1.0, 1.2));
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Cat.class, 6.0f, 1.0, 1.2));
        this.f_21345_.m_25352_(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(5, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 5, true, false, target -> this.getOwnerAsPlayer().map(owner -> this.shouldAttackEntity((LivingEntity)target, (LivingEntity)owner)).orElse(true)));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CLIMBING, (Object)0);
        this.f_19804_.m_135372_(COLOR, (Object)0);
        this.f_19804_.m_135372_(STATE, (Object)((byte)Flags.setFlag(0, Flags.IDLE)));
    }

    @Override
    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128376_("MaxFuseTime", this.maxFuseTimer);
        nbt.m_128379_("Ignited", this.isIgnited());
    }

    @Override
    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        if (nbt.m_128425_("MaxFuseTime", 99)) {
            this.maxFuseTimer = nbt.m_128448_("MaxFuseTime");
        }
        this.setIgnited(nbt.m_128471_("Ignited"));
        ItemStack storedPotion = this.getStoredPotion();
    }

    public PathNavigation m_21573_() {
        return new WallClimberNavigation((Mob)this, this.m_9236_());
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        return super.m_6518_(level, difficulty, reason, spawnData, dataTag);
    }

    public void m_8119_() {
        if (this.m_6084_()) {
            this.prevFuseTimer = this.fuseTimer;
            if (this.isIgnited()) {
                this.setIdle(false);
            }
            if (!this.isIdle()) {
                if (this.fuseTimer == 0) {
                    this.m_5496_(SoundEvents.f_11837_, 1.0f, 0.5f);
                }
                if (++this.fuseTimer >= this.maxFuseTimer) {
                    this.fuseTimer = this.maxFuseTimer;
                    this.explode();
                }
            } else if (--this.fuseTimer < 0) {
                this.fuseTimer = 0;
            }
        }
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            this.setBesideClimbableBlock(this.f_19862_);
        }
    }

    public boolean m_7327_(Entity entity) {
        return true;
    }

    public boolean isBesideClimbableBlock() {
        return ((Byte)this.f_19804_.m_135370_(CLIMBING) & 1) != 0;
    }

    public void setBesideClimbableBlock(boolean isClimbing) {
        byte flag = (Byte)this.f_19804_.m_135370_(CLIMBING);
        flag = isClimbing ? (byte)(flag | 1) : (byte)(flag & 0xFFFFFFFE);
        this.f_19804_.m_135381_(CLIMBING, (Object)flag);
    }

    public boolean m_6147_() {
        return this.isBesideClimbableBlock();
    }

    public void m_7601_(BlockState state, Vec3 motionMultiplierIn) {
        if (!state.m_60713_(Blocks.f_50033_)) {
            super.m_7601_(state, motionMultiplierIn);
        }
    }

    public ItemStack getStoredPotion() {
        return this.m_6844_(EquipmentSlot.MAINHAND);
    }

    public void setStoredPotion(ItemStack stack) {
        this.m_8061_(EquipmentSlot.MAINHAND, stack);
    }

    public byte getState() {
        return (Byte)this.m_20088_().m_135370_(STATE);
    }

    public boolean isIdle() {
        return Flags.isFlagSet(((Byte)this.m_20088_().m_135370_(STATE)).byteValue(), Flags.IDLE);
    }

    public void setIdle(boolean bool) {
        this.setStateFlag(Flags.IDLE, bool);
    }

    public boolean isIgnited() {
        return Flags.isFlagSet(((Byte)this.m_20088_().m_135370_(STATE)).byteValue(), Flags.IGNITED);
    }

    public void setIgnited(boolean bool) {
        this.setStateFlag(Flags.IGNITED, bool);
    }

    public void setStateFlag(Flags flag, boolean bool) {
        byte value = (Byte)this.m_20088_().m_135370_(STATE);
        byte flags = (byte)(bool ? Flags.setFlag(value, flag) : Flags.unsetFlag(value, flag));
        this.m_20088_().m_135381_(STATE, (Object)flags);
    }

    public short getMaxFuseTimer() {
        return this.maxFuseTimer;
    }

    public void setMaxFuseTimer(short maxFuseTimer) {
        this.maxFuseTimer = maxFuseTimer;
    }

    public int getColor() {
        return (Integer)this.m_20088_().m_135370_(COLOR);
    }

    public boolean m_7301_(MobEffectInstance effectInstance) {
        return false;
    }

    @Override
    public void m_6667_(@Nonnull DamageSource cause) {
        super.m_6667_(cause);
        if (!(this.m_9236_().f_46443_ || cause.m_276093_(DamageTypes.f_268530_) || cause.m_269533_(DamageTypeTags.f_268745_) || cause.m_269533_(DamageTypeTags.f_268415_) || cause.m_269533_(DamageTypeTags.f_268419_))) {
            this.explode();
        }
    }

    private void explode() {
        if (this.m_9236_().f_46443_) {
            return;
        }
        ItemStack stack = this.getStoredPotion();
        if (stack.m_41619_()) {
            return;
        }
        Potion potion = PotionUtils.m_43579_((ItemStack)stack);
        List effects = PotionUtils.m_43547_((ItemStack)stack);
        if (potion == Potions.f_43599_ && effects.isEmpty()) {
            this.causeWaterAOE();
            this.m_146870_();
        } else if (!effects.isEmpty()) {
            this.spawnEffectAOE(stack, potion);
            this.m_146870_();
        }
    }

    private void spawnEffectAOE(ItemStack stack, Potion potion) {
        Optional<Player> owner = this.getOwnerAsPlayer();
        Boomling shooter = owner.isPresent() ? (LivingEntity)owner.get() : this;
        CompoundTag nbt = stack.m_41783_();
        int color = PotionUtils.m_43575_((ItemStack)stack);
        if (nbt != null && nbt.m_128425_("CustomPotionColor", 99)) {
            color = nbt.m_128451_("CustomPotionColor");
        }
        List effects = PotionUtils.m_43571_((ItemStack)stack);
        Boomling.spawnEffectAOE(this.m_9236_(), (LivingEntity)shooter, this.m_20182_(), potion, effects, color);
    }

    private void causeWaterAOE() {
        Optional<Player> owner = this.getOwnerAsPlayer();
        Boomling shooter = owner.isPresent() ? (LivingEntity)owner.get() : this;
        CombatUtil.performWaterAOE(this.m_9236_(), (Entity)shooter, 4.0);
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (!this.isOwner((Entity)player)) {
            return InteractionResult.PASS;
        }
        return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
    }

    protected float m_6431_(@Nonnull Pose pose, @Nonnull EntityDimensions dim) {
        return 0.16f;
    }

    protected float m_6121_() {
        return 0.4f;
    }

    public void m_8032_() {
        SoundEvent soundevent = this.m_7515_();
        if (soundevent != null) {
            this.m_5496_(soundevent, this.m_6121_(), this.m_6100_() * 1.2f);
        }
    }

    protected void m_6677_(DamageSource source) {
        this.f_21363_ = -this.m_8100_();
        SoundEvent soundevent = this.m_7975_(source);
        if (soundevent != null) {
            this.m_5496_(soundevent, this.m_6121_(), this.m_6100_() * 1.2f);
        }
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(SoundEvents.f_12435_, 0.1f, 1.2f);
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12432_;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_12468_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12467_;
    }

    @Override
    public boolean tryToReturnIntoPlayerInventory() {
        return false;
    }

    public float getExplodeProgress(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.prevFuseTimer, (float)this.fuseTimer) / ((float)this.maxFuseTimer - 2.0f);
    }

    private <T extends Boomling> PlayState handleAnim(AnimationState<T> state) {
        state.getController().transitionLength(0);
        if (!this.isIdle() && this.getExplodeProgress(state.getPartialTick()) > 0.0f) {
            state.getController().setAnimation(RawAnimation.begin().thenPlay("boomling.anim.explode"));
            return PlayState.CONTINUE;
        }
        if (state.isMoving()) {
            state.getController().setAnimation(RawAnimation.begin().thenPlay("boomling.anim.armed"));
            return PlayState.CONTINUE;
        }
        state.getController().transitionLength(5);
        state.getController().setAnimation(RawAnimation.begin().thenLoop("boomling.anim.idle"));
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "main", 0, this::handleAnim)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    class ExplodeGoal
    extends Goal {
        ExplodeGoal() {
        }

        public boolean m_8036_() {
            return Boomling.this.m_5448_() != null && Boomling.this.m_20280_((Entity)Boomling.this.m_5448_()) < 12.25;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            LivingEntity target = Boomling.this.m_5448_();
            if (target == null) {
                Boomling.this.setIdle(true);
            } else if (Boomling.this.m_20280_((Entity)target) > 12.25) {
                Boomling.this.setIdle(true);
            } else {
                Boomling.this.setIdle(!Boomling.this.m_21574_().m_148306_((Entity)target));
            }
        }
    }

    public static enum Flags {
        IGNITED,
        IDLE;

        private final int bitPosition = 1 << this.ordinal();

        public static boolean isFlagSet(int value, Flags flag) {
            return (value & flag.bitPosition) != 0;
        }

        public static int setFlag(int value, Flags flag) {
            return value | flag.bitPosition;
        }

        public static int unsetFlag(int value, Flags flag) {
            return value & ~flag.bitPosition;
        }
    }
}

