/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.entity.mob;

import com.github.elenterius.biomancy.entity.mob.ControllableMob;
import com.github.elenterius.biomancy.entity.mob.OwnableMonster;
import com.github.elenterius.biomancy.entity.mob.ai.goal.controllable.CopyOwnerAttackTargetGoal;
import com.github.elenterius.biomancy.entity.mob.ai.goal.controllable.CopyOwnerRevengeTargetGoal;
import com.github.elenterius.biomancy.entity.mob.ai.goal.controllable.FindAttackTargetGoal;
import com.github.elenterius.biomancy.entity.mob.ai.goal.controllable.FollowOwnerGoal;
import com.github.elenterius.biomancy.entity.mob.ai.goal.controllable.PatrolAreaGoal;
import com.github.elenterius.biomancy.entity.mob.ai.goal.controllable.ReturnToHomePosGoal;
import com.github.elenterius.biomancy.ownable.OwnableMob;
import com.github.elenterius.biomancy.styles.TextComponentUtil;
import com.github.elenterius.biomancy.util.ComponentUtil;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.level.Level;

@Deprecated
public class FleshkinHumanoid
extends OwnableMonster
implements ControllableMob<FleshkinHumanoid> {
    private static final EntityDataAccessor<Boolean> IS_CHILD = SynchedEntityData.m_135353_(FleshkinHumanoid.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Byte> BEHAVIOR_COMMAND = SynchedEntityData.m_135353_(FleshkinHumanoid.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Boolean> IS_CHARGING_CROSSBOW = SynchedEntityData.m_135353_(FleshkinHumanoid.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final UUID SPEED_BOOST_UUID = UUID.fromString("7ac9f8fa-3d7c-48e5-9690-fa7025723b04");
    private static final AttributeModifier SPEED_MODIFIER = new AttributeModifier(SPEED_BOOST_UUID, "speed boost", (double)0.2f, AttributeModifier.Operation.MULTIPLY_BASE);

    public FleshkinHumanoid(EntityType<? extends Monster> type, Level level) {
        super(type, level);
        this.m_21553_(true);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22277_, 35.0).m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22284_, 2.0).m_22268_(Attributes.f_22279_, 0.35).m_22268_(Attributes.f_22281_, 4.0);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_CHILD, (Object)true);
        this.f_19804_.m_135372_(BEHAVIOR_COMMAND, (Object)ControllableMob.Command.DEFEND_OWNER.serialize());
        this.f_19804_.m_135372_(IS_CHARGING_CROSSBOW, (Object)false);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(3, (Goal)new MoveTowardsTargetGoal((PathfinderMob)this, 0.9, 36.0f));
        this.f_21345_.m_25352_(3, new ReturnToHomePosGoal<FleshkinHumanoid>(this, 0.6, false));
        this.f_21345_.m_25352_(4, new PatrolAreaGoal<FleshkinHumanoid>(this, 0.6));
        this.f_21345_.m_25352_(5, new FollowOwnerGoal<FleshkinHumanoid>(this, 1.0, 10.0f, 2.0f, false));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, new CopyOwnerRevengeTargetGoal<FleshkinHumanoid>(this));
        this.f_21346_.m_25352_(2, new CopyOwnerAttackTargetGoal<FleshkinHumanoid>(this));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(4, new FindAttackTargetGoal<FleshkinHumanoid, Mob>(this, Mob.class, 5, false, false, target -> {
            if (target instanceof Enemy) {
                Optional<Player> owner;
                if (target instanceof OwnableMob && (owner = this.getOwnerAsPlayer()).isPresent()) {
                    return this.shouldAttackEntity((LivingEntity)target, (LivingEntity)owner.get());
                }
                return true;
            }
            return false;
        }));
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        if (this.getActiveCommand() == ControllableMob.Command.SIT) {
            this.setActiveCommand(ControllableMob.Command.PATROL_AREA);
        }
        return super.m_6469_(source, amount);
    }

    public static void displayCommandSetMsg(Player player, Component name, ControllableMob.Command newCommand) {
        MutableComponent cmd = ComponentUtil.literal(newCommand.toString()).m_130940_(ChatFormatting.DARK_AQUA);
        MutableComponent text = TextComponentUtil.getMsgText("set_behavior_command", name, cmd).m_130940_(ChatFormatting.WHITE);
        player.m_5661_((Component)text, true);
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        Item item;
        if (player.m_7500_() && (item = player.m_21205_().m_41720_()) == Items.f_42751_) {
            this.setOwner((Entity)player);
            player.m_5661_((Component)ComponentUtil.literal("You are now the owner of this creature!").m_130940_(ChatFormatting.RED), true);
        }
        if (!player.m_21205_().m_41619_() || !this.isOwner((Entity)player)) {
            return InteractionResult.PASS;
        }
        if (!player.m_9236_().m_5776_() && player.m_6144_()) {
            ControllableMob.Command newCommand = this.getActiveCommand().cycle();
            this.updateRestriction(newCommand);
            this.setActiveCommand(newCommand);
            FleshkinHumanoid.displayCommandSetMsg(player, this.m_7755_(), newCommand);
        }
        return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
    }

    @Override
    public ControllableMob.Command getActiveCommand() {
        return ControllableMob.Command.deserialize((byte)((Byte)this.f_19804_.m_135370_(BEHAVIOR_COMMAND) & 0xF));
    }

    @Override
    public void setActiveCommand(ControllableMob.Command commandIn) {
        int prevCommand = ((Byte)this.f_19804_.m_135370_(BEHAVIOR_COMMAND) & 0xF) << 4;
        byte newCommand = commandIn.serialize();
        this.f_19804_.m_135381_(BEHAVIOR_COMMAND, (Object)((byte)(prevCommand | newCommand)));
    }

    public ControllableMob.Command getGolemCommand(byte packedCommands) {
        return ControllableMob.Command.deserialize((byte)(packedCommands & 0xF));
    }

    public ControllableMob.Command getPreviousGolemCommand(byte packedCommands) {
        return ControllableMob.Command.deserialize((byte)(packedCommands >> 4));
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("IsBaby", this.m_6162_());
        tag.m_128344_("GolemCommand", ((Byte)this.f_19804_.m_135370_(BEHAVIOR_COMMAND)).byteValue());
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.m_6863_(tag.m_128471_("IsBaby"));
        this.f_19804_.m_135381_(BEHAVIOR_COMMAND, (Object)tag.m_128445_("GolemCommand"));
    }

    public void m_7822_(byte id) {
        super.m_7822_(id);
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        super.m_7350_(key);
        if (IS_CHILD.equals(key)) {
            this.m_6210_();
        }
    }

    protected float m_21519_(EquipmentSlot slot) {
        return 2.0f;
    }

    public boolean m_6162_() {
        return (Boolean)this.f_19804_.m_135370_(IS_CHILD);
    }

    public void m_6863_(boolean isChild) {
        AttributeInstance attribute;
        this.f_19804_.m_135381_(IS_CHILD, (Object)isChild);
        if (!this.m_9236_().f_46443_ && (attribute = this.m_21051_(Attributes.f_22279_)) != null) {
            attribute.m_22130_(SPEED_MODIFIER);
            if (isChild) {
                attribute.m_22118_(SPEED_MODIFIER);
            }
        }
    }

    protected float m_6431_(Pose poseIn, EntityDimensions dim) {
        return this.m_6162_() ? 0.93f : 1.74f;
    }

    public boolean m_7243_(ItemStack stack) {
        Item item = stack.m_41720_();
        return item instanceof ArmorItem || item instanceof TieredItem || item instanceof ShieldItem || item instanceof ProjectileWeaponItem;
    }

    public boolean m_5886_(ProjectileWeaponItem item) {
        return item == Items.f_42717_;
    }

    private boolean isChargingCrossbow() {
        return (Boolean)this.f_19804_.m_135370_(IS_CHARGING_CROSSBOW);
    }

    public void setChargingCrossbow(boolean isCharging) {
        this.f_19804_.m_135381_(IS_CHARGING_CROSSBOW, (Object)isCharging);
    }

    public boolean isHoldingMeleeWeapon() {
        return this.m_21205_().m_41720_() instanceof TieredItem;
    }

    @Override
    public ControllableMob.Action getCurrentAction() {
        if (this.m_5912_() && this.isHoldingMeleeWeapon()) {
            return ControllableMob.Action.ATTACKING_WITH_MELEE_WEAPON;
        }
        if (this.isChargingCrossbow()) {
            return ControllableMob.Action.CROSSBOW_CHARGE;
        }
        return this.m_5912_() && this.m_21055_(Items.f_42717_) ? ControllableMob.Action.CROSSBOW_HOLD : ControllableMob.Action.IDLE;
    }

    @Override
    public boolean tryToReturnIntoPlayerInventory() {
        return false;
    }
}

