/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.entity.mob;

import com.github.elenterius.biomancy.mixin.MobEntityAccessor;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.control.JumpControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public class JumpMoveHelper<T extends PathfinderMob> {
    public static final int MAX_JUMP_DURATION = 20;
    protected static final float MAX_Y_ROT_CHANGE = 4.5f;
    private final byte stateUpdateId;
    private final JumpController jumpController;
    private final MoveController moveController;
    private final T jumpingMob;
    private int jumpDuration;
    private int jumpTicks;
    private boolean wasOnGround;
    private int jumpDelay;

    public JumpMoveHelper(T mob, byte stateUpdateId) {
        this.jumpingMob = mob;
        this.stateUpdateId = stateUpdateId;
        this.jumpController = new JumpController(this, mob);
        this.moveController = new MoveController(this, mob);
        MobEntityAccessor mobAccessor = (MobEntityAccessor)mob;
        mobAccessor.biomancy$setJumpControl(this.jumpController);
        mobAccessor.biomancy$setMoveControl(this.moveController);
        this.setSpeedModifier(0.0);
    }

    private void setSpeedModifier(double speed) {
        this.jumpingMob.m_21573_().m_26517_(speed);
        this.moveController.m_6849_(this.moveController.m_25000_(), this.moveController.m_25001_(), this.moveController.m_25002_(), speed);
    }

    public void startJumping() {
        this.jumpingMob.m_6862_(true);
        this.jumpDuration = 20;
        this.jumpTicks = 0;
    }

    public boolean handleEntityEvent(byte id) {
        if (id == this.stateUpdateId) {
            ((JumpingPathfinderMob)this.jumpingMob).spawnJumpParticle();
            this.jumpDuration = 20;
            this.jumpTicks = 0;
            return true;
        }
        return false;
    }

    public void onJumpFromGround() {
        if (!this.jumpingMob.m_9236_().f_46443_) {
            this.jumpingMob.m_9236_().m_7605_(this.jumpingMob, this.stateUpdateId);
        }
    }

    public void onAiStep() {
        if (this.jumpTicks != this.jumpDuration) {
            ++this.jumpTicks;
        } else if (this.jumpDuration != 0) {
            this.jumpTicks = 0;
            this.jumpDuration = 0;
            this.jumpingMob.m_6862_(false);
        }
    }

    public void onCustomServerAiStep() {
        if (this.jumpDelay > 0) {
            --this.jumpDelay;
        }
        if (this.jumpingMob.m_20096_()) {
            LivingEntity target;
            if (!this.wasOnGround) {
                this.jumpingMob.m_6862_(false);
                this.jumpDelay = this.moveController.m_24999_() < 2.2 ? 20 : 1;
                this.jumpController.setCanJump(false);
            }
            if (this.jumpDelay == 0 && (target = this.jumpingMob.m_5448_()) != null && this.jumpingMob.m_20280_((Entity)target) < 16.0) {
                this.moveController.m_6849_(target.m_20185_(), target.m_20186_(), target.m_20189_(), this.moveController.m_24999_());
                this.setJumpHeading(target.m_20185_(), target.m_20189_());
                this.startJumping();
                this.wasOnGround = true;
            }
            if (!this.jumpController.wantsToJump()) {
                if (this.jumpDelay == 0 && this.moveController.m_24995_()) {
                    Path path = this.jumpingMob.m_21573_().m_26570_();
                    Vec3 heading = path != null && !path.m_77392_() ? path.m_77380_(this.jumpingMob) : new Vec3(this.moveController.m_25000_(), this.moveController.m_25001_(), this.moveController.m_25002_());
                    this.setJumpHeading(heading.f_82479_, heading.f_82481_);
                    this.startJumping();
                }
            } else if (!this.jumpController.canJump()) {
                this.jumpController.setCanJump(true);
            }
        }
        this.wasOnGround = this.jumpingMob.m_20096_();
    }

    public void setJumpHeading(double x, double z) {
        Vec3 pos = this.jumpingMob.m_20182_();
        float bodyRotation = (float)(Mth.m_14136_((double)(z - pos.f_82481_), (double)(x - pos.f_82479_)) * 57.2957763671875) - 90.0f;
        this.jumpingMob.m_146922_(this.moveController.m_24991_(this.jumpingMob.m_146908_(), bodyRotation, 4.5f));
    }

    public float getJumpCompletionPct(float partialTicks) {
        return this.jumpDuration == 0 ? 0.0f : ((float)this.jumpTicks + partialTicks) / (float)this.jumpDuration;
    }

    public static class JumpController
    extends JumpControl {
        private boolean canJump;
        final /* synthetic */ JumpMoveHelper this$0;

        public JumpController(T jumpingMob) {
            this.this$0 = this$0;
            super(jumpingMob);
        }

        public boolean wantsToJump() {
            return this.f_24897_;
        }

        public boolean canJump() {
            return this.canJump;
        }

        public void setCanJump(boolean flag) {
            this.canJump = flag;
        }

        public void m_8124_() {
            if (this.f_24897_) {
                this.this$0.startJumping();
                this.f_24897_ = false;
            }
        }
    }

    public static class MoveController
    extends MoveControl {
        private double nextJumpSpeed;
        final /* synthetic */ JumpMoveHelper this$0;

        public MoveController(T jumpingMob) {
            this.this$0 = this$0;
            super(jumpingMob);
        }

        protected float m_24991_(float sourceAngle, float targetAngle, float maximumChange) {
            return super.m_24991_(sourceAngle, targetAngle, maximumChange);
        }

        public void m_8126_() {
            if (this.this$0.jumpingMob.m_20096_() && !((JumpingPathfinderMob)this.this$0.jumpingMob).isJumping() && !this.this$0.jumpController.wantsToJump()) {
                this.this$0.setSpeedModifier(0.0);
            } else if (this.m_24995_()) {
                this.this$0.setSpeedModifier(this.nextJumpSpeed);
            }
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO) {
                double motionMultiplier = 1.0;
                Vec3 motionDiff = new Vec3(this.f_24975_ - this.this$0.jumpingMob.m_20185_(), this.f_24976_ - this.this$0.jumpingMob.m_20186_(), this.f_24977_ - this.this$0.jumpingMob.m_20189_());
                float targetYRot = (float)(Mth.m_14136_((double)motionDiff.f_82481_, (double)motionDiff.f_82479_) * 57.2957763671875) - 90.0f;
                float yRot = this.m_24991_(this.this$0.jumpingMob.m_146908_(), targetYRot, 4.5f);
                this.this$0.jumpingMob.m_146922_(yRot);
                float yRotChange = Mth.m_14177_((float)(targetYRot - yRot));
                if (yRotChange < -4.5f || yRotChange > 4.5f) {
                    this.this$0.jumpingMob.m_21564_(0.0f);
                    return;
                }
                this.f_24981_ = MoveControl.Operation.WAIT;
                double length = motionDiff.m_82553_();
                double lengthSqr = motionDiff.m_82556_();
                if (lengthSqr >= 1.0E-7) {
                    double speed = this.f_24978_ * (double)0.05f;
                    Vec3 motion = motionDiff.m_82490_(speed / length * motionMultiplier);
                    this.this$0.jumpingMob.m_20256_(this.this$0.jumpingMob.m_20184_().m_82549_(motion));
                }
            }
            super.m_8126_();
        }

        public void m_6849_(double x, double y, double z, double speed) {
            if (this.this$0.jumpingMob.m_20069_()) {
                speed = 1.5;
            }
            super.m_6849_(x, y, z, speed);
            if (speed > 0.0) {
                this.nextJumpSpeed = speed;
            }
        }
    }

    public static interface JumpingPathfinderMob {
        public void spawnJumpParticle();

        public boolean isJumping();

        public SoundEvent getJumpSound();
    }
}

