/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.entity.mob.ai.goal;

import com.github.elenterius.biomancy.entity.mob.FoodEater;
import java.util.EnumSet;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;

public class EatFoodItemGoal<T extends PathfinderMob>
extends Goal {
    protected static final int EATING_TICKS = 44;
    private final T mob;
    private final float eatChance;
    private int eatTimer;

    public EatFoodItemGoal(T mob) {
        this(mob, 0.01f);
    }

    public EatFoodItemGoal(T mob, float eatChance) {
        this.mob = mob;
        this.eatChance = eatChance;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
    }

    public boolean m_8036_() {
        if (this.mob.m_217043_().m_188501_() < this.eatChance) {
            return this.hasEdibleFood();
        }
        return false;
    }

    protected boolean hasEdibleFood() {
        return ((FoodEater)this.mob).getFoodItem().m_41614_();
    }

    public boolean m_8045_() {
        return this.eatTimer > 0 && this.hasEdibleFood();
    }

    public void m_8056_() {
        this.eatTimer = this.m_183277_(((FoodEater)this.mob).getFoodItem().m_41779_() * 2);
        this.mob.m_21573_().m_26573_();
        ((FoodEater)this.mob).setEating(true);
    }

    public void m_8041_() {
        this.eatTimer = 0;
        ((FoodEater)this.mob).setEating(false);
    }

    public void m_8037_() {
        this.eatTimer = Math.max(0, this.eatTimer - 1);
        if (this.eatTimer == this.m_183277_(4)) {
            if (this.hasEdibleFood()) {
                ItemStack stack = ((FoodEater)this.mob).getFoodItem();
                FoodProperties food = stack.getFoodProperties(this.mob);
                ItemStack eatenStack = stack.m_41671_(this.mob.m_9236_(), this.mob);
                if (!eatenStack.m_41619_()) {
                    ((FoodEater)this.mob).setFoodItem(eatenStack);
                }
                ((FoodEater)this.mob).ate(food);
            }
            ((FoodEater)this.mob).setEating(false);
        }
    }
}

