/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.entity.mob.fleshblob;

import com.github.elenterius.biomancy.entity.mob.Fleshkin;
import com.github.elenterius.biomancy.entity.mob.JukeboxDancer;
import com.github.elenterius.biomancy.entity.mob.JumpMoveHelper;
import com.github.elenterius.biomancy.entity.mob.fleshblob.FleshBlobSpawnData;
import com.github.elenterius.biomancy.entity.mob.fleshblob.TumorFlag;
import com.github.elenterius.biomancy.init.ModLoot;
import com.github.elenterius.biomancy.init.ModSoundEvents;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.DynamicGameEventListener;
import net.minecraft.world.level.gameevent.EntityPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public abstract class FleshBlob
extends PathfinderMob
implements Fleshkin,
JumpMoveHelper.JumpingPathfinderMob,
JukeboxDancer,
GeoEntity {
    public static final byte MAX_SIZE = 10;
    public static final byte MIN_SIZE = 1;
    public static final byte JUMPING_STATE_ID = 61;
    protected static final RawAnimation ON_GROUND_ANIMATION = RawAnimation.begin().thenLoop("ground.loop");
    protected static final RawAnimation JUMP_START_ANIMATION = RawAnimation.begin().thenPlay("jump.startup").thenPlayAndHold("jump.air.loop");
    protected static final RawAnimation JUMP_IN_AIR_ANIMATION = RawAnimation.begin().thenLoop("jump.air.loop");
    protected static final RawAnimation JUMP_LAND_ANIMATION = RawAnimation.begin().thenPlay("jump.impact");
    protected static final RawAnimation EATING_ANIMATION = RawAnimation.begin().thenLoop("eating.loop");
    protected static final RawAnimation DANCE_ANIMATION = RawAnimation.begin().thenPlay("dancing.loop");
    protected static final EntityDataAccessor<Byte> BLOB_SIZE = SynchedEntityData.m_135353_(FleshBlob.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    protected static final EntityDataAccessor<Byte> TUMORS = SynchedEntityData.m_135353_(FleshBlob.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    protected static final EntityDataAccessor<Boolean> IS_DANCING = SynchedEntityData.m_135353_(FleshBlob.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected final JumpMoveHelper<FleshBlob> jumpMoveHelper = new JumpMoveHelper<FleshBlob>(this, 61);
    protected final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final DynamicGameEventListener<JukeboxListener> dynamicJukeboxListener = new DynamicGameEventListener((GameEventListener)new JukeboxListener((PositionSource)new EntityPositionSource((Entity)this, this.m_20192_()), GameEvent.f_238690_.m_157827_()));
    protected int pettingDelay = 0;
    @Nullable
    private BlockPos jukeboxPos;

    protected FleshBlob(EntityType<? extends FleshBlob> entityType, Level level) {
        super(entityType, level);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        if (spawnData instanceof FleshBlobSpawnData) {
            FleshBlobSpawnData data = (FleshBlobSpawnData)spawnData;
            this.setTumorFlags(data.tumorFlags());
        } else {
            byte tumorFlags = TumorFlag.randomFlags(this.f_19796_);
            this.setTumorFlags(tumorFlags);
            spawnData = new FleshBlobSpawnData.Tumors(tumorFlags);
        }
        this.setBlobSize((byte)1, true);
        if (reason == MobSpawnType.SPAWNER) {
            this.f_21364_ = 0;
        }
        return super.m_6518_(level, difficulty, reason, spawnData, dataTag);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(BLOB_SIZE, (Object)1);
        this.f_19804_.m_135372_(TUMORS, (Object)0);
        this.f_19804_.m_135372_(IS_DANCING, (Object)false);
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        if (BLOB_SIZE.equals(key)) {
            this.m_6210_();
            this.m_146922_(this.f_20885_);
            this.m_5618_(this.f_20885_);
            if (this.m_20069_() && this.f_19796_.m_188501_() < 0.05f) {
                this.m_5841_();
            }
        }
        super.m_7350_(key);
    }

    public void m_213651_(BiConsumer<DynamicGameEventListener<?>, ServerLevel> listener) {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            listener.accept(this.dynamicJukeboxListener, serverlevel);
        }
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    public EntityDimensions m_6972_(Pose pose) {
        return super.m_6972_(pose).m_20388_(this.getBlobScale());
    }

    public float getBlobScale() {
        return 0.5f + (float)this.getBlobSize() * 0.25f;
    }

    public int m_8132_() {
        return 0;
    }

    public void m_6210_() {
        double x = this.m_20185_();
        double y = this.m_20186_();
        double z = this.m_20189_();
        super.m_6210_();
        this.m_6034_(x, y, z);
    }

    protected float m_6431_(Pose pose, EntityDimensions size) {
        return size.f_20378_ * 0.5f;
    }

    public static byte clamp(byte v, byte min, byte max) {
        return (byte)Math.min(Math.max(v, min), max);
    }

    public void setBlobSize(byte size, boolean resetHealth) {
        size = FleshBlob.clamp(size, (byte)1, (byte)10);
        this.f_19804_.m_135381_(BLOB_SIZE, (Object)size);
        this.m_20090_();
        this.m_6210_();
        this.updateBaseAttributes(size);
        if (resetHealth) {
            this.m_21153_(this.m_21233_());
        }
        this.f_21364_ = size;
    }

    protected abstract void updateBaseAttributes(byte var1);

    public byte getBlobSize() {
        return (Byte)this.f_19804_.m_135370_(BLOB_SIZE);
    }

    public void randomizeTumors() {
        this.f_19804_.m_135381_(TUMORS, (Object)((byte)this.f_19796_.m_188503_(128)));
    }

    public void setTumors(float tumorFactor) {
        int flags = 0;
        if (tumorFactor > 0.0f) {
            for (TumorFlag flag : TumorFlag.values()) {
                if (!(this.m_9236_().f_46441_.m_188501_() < tumorFactor)) continue;
                flags = TumorFlag.setFlag(flags, flag);
            }
        }
        this.f_19804_.m_135381_(TUMORS, (Object)((byte)flags));
    }

    public byte getTumorFlags() {
        return (Byte)this.f_19804_.m_135370_(TUMORS);
    }

    public void setTumorFlags(byte flags) {
        this.f_19804_.m_135381_(TUMORS, (Object)flags);
    }

    @Override
    public boolean isDancing() {
        return (Boolean)this.f_19804_.m_135370_(IS_DANCING);
    }

    @Override
    public void setDancing(boolean dancing) {
        if (!this.m_9236_().f_46443_) {
            this.f_19804_.m_135381_(IS_DANCING, (Object)dancing);
        }
    }

    @Override
    @Nullable
    public BlockPos getJukeboxPos() {
        return this.jukeboxPos;
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128344_("Size", this.getBlobSize());
        tag.m_128344_("Tumors", this.getTumorFlags());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setBlobSize(tag.m_128445_("Size"), false);
        this.setTumorFlags(tag.m_128445_("Tumors"));
    }

    protected ResourceLocation m_7582_() {
        return switch (this.getBlobSize()) {
            case 2 -> ModLoot.Entity.FLESH_BLOB_SIZE_2;
            case 3 -> ModLoot.Entity.FLESH_BLOB_SIZE_3;
            case 4 -> ModLoot.Entity.FLESH_BLOB_SIZE_4;
            case 5 -> ModLoot.Entity.FLESH_BLOB_SIZE_5;
            case 6 -> ModLoot.Entity.FLESH_BLOB_SIZE_6;
            case 7 -> ModLoot.Entity.FLESH_BLOB_SIZE_7;
            case 8 -> ModLoot.Entity.FLESH_BLOB_SIZE_8;
            case 9 -> ModLoot.Entity.FLESH_BLOB_SIZE_9;
            case 10 -> ModLoot.Entity.FLESH_BLOB_SIZE_10;
            default -> this.m_6095_().m_20677_();
        };
    }

    protected void m_6135_() {
        super.m_6135_();
        this.jumpMoveHelper.onJumpFromGround();
    }

    public void m_8107_() {
        super.m_8107_();
        this.jumpMoveHelper.onAiStep();
        if (this.f_19797_ % 20 == 0 && this.isDancing() && this.shouldStopDancing()) {
            this.setDancing(false);
            this.jukeboxPos = null;
        }
        if (this.pettingDelay > 0) {
            --this.pettingDelay;
        }
    }

    protected boolean shouldStopDancing() {
        boolean wasHurt;
        boolean bl = wasHurt = this.f_20888_ != null || this.m_21188_() != null;
        if (wasHurt) {
            return true;
        }
        return this.jukeboxPos == null || !this.jukeboxPos.m_203195_((Position)this.m_20182_(), (double)GameEvent.f_238690_.m_157827_()) || !this.m_9236_().m_8055_(this.jukeboxPos).m_60713_(Blocks.f_50131_);
    }

    protected void m_8024_() {
        this.jumpMoveHelper.onCustomServerAiStep();
    }

    public void m_7822_(byte id) {
        if (this.jumpMoveHelper.handleEntityEvent(id)) {
            return;
        }
        super.m_7822_(id);
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41619_()) {
            if (!this.m_9236_().f_46443_ && this.pettingDelay <= 0) {
                this.pettingDelay = this.f_19796_.m_216332_(10, 20);
                if (this instanceof Enemy) {
                    this.m_5496_((SoundEvent)ModSoundEvents.FLESH_BLOB_GROWL.get(), this.m_6121_(), this.m_6100_());
                    double offset = (double)this.m_20205_() * 0.5;
                    ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123792_, this.m_20185_(), this.m_20227_(1.0) - 0.2, this.m_20189_(), 3, offset, 0.1, offset, 1.0);
                } else {
                    this.m_5496_((SoundEvent)ModSoundEvents.FLESH_BLOB_MEW_PURR.get(), this.m_6121_(), this.m_6100_());
                    double offset = (double)this.m_20205_() * 0.5;
                    ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123750_, this.m_20185_(), this.m_20227_(1.0) - 0.2, this.m_20189_(), 3, offset, 0.1, offset, 1.0);
                }
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(player, hand);
    }

    public float m_6100_() {
        return (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.4f + 0.8f;
    }

    @Override
    public void spawnJumpParticle() {
        this.m_20076_();
    }

    @Override
    public boolean isJumping() {
        return this.f_20899_;
    }

    public void m_6862_(boolean jumping) {
        super.m_6862_(jumping);
        if (jumping && !this.m_20072_()) {
            this.m_5496_(this.getJumpSound(), this.m_6121_(), ((float)this.f_19796_.m_188583_() * 0.2f + 1.0f) * 0.8f);
        }
    }

    @Override
    public SoundEvent getJumpSound() {
        return (SoundEvent)ModSoundEvents.FLESH_BLOB_JUMP.get();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)ModSoundEvents.FLESH_BLOB_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSoundEvents.FLESH_BLOB_DEATH.get();
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSoundEvents.FLESH_BLOB_AMBIENT.get();
    }

    public boolean m_5843_() {
        return false;
    }

    public void setJukeboxPlaying(BlockPos pos, boolean isJukeboxPlaying) {
        if (isJukeboxPlaying) {
            boolean wasHurt;
            boolean bl = wasHurt = this.f_20888_ != null || this.m_21188_() != null;
            if (!this.isDancing() && !wasHurt) {
                this.jukeboxPos = pos;
                this.setDancing(true);
            }
        } else if (pos.equals((Object)this.jukeboxPos) || this.jukeboxPos == null) {
            this.jukeboxPos = null;
            this.setDancing(false);
        }
    }

    protected <T extends FleshBlob> PlayState handleJumpAnimation(AnimationState<T> event) {
        float jumpPct = this.jumpMoveHelper.getJumpCompletionPct(event.getPartialTick());
        if (jumpPct > 0.0f) {
            event.getController().transitionLength(0);
            if (jumpPct <= 0.28f) {
                event.getController().setAnimation(JUMP_START_ANIMATION);
            } else if (jumpPct < 0.72f) {
                event.getController().setAnimation(JUMP_IN_AIR_ANIMATION);
            } else {
                event.getController().setAnimation(JUMP_LAND_ANIMATION);
            }
        } else {
            event.getController().transitionLength(10);
            event.getController().setAnimation(ON_GROUND_ANIMATION);
        }
        return PlayState.CONTINUE;
    }

    protected <T extends FleshBlob> PlayState handleDanceAnimation(AnimationState<T> state) {
        if (this.isDancing()) {
            state.getController().setAnimation(DANCE_ANIMATION);
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "jump", 0, this::handleJumpAnimation)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "dance", 10, this::handleDanceAnimation)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    protected class JukeboxListener
    implements GameEventListener {
        private final PositionSource listenerSource;
        private final int listenerRadius;

        public JukeboxListener(PositionSource positionSource, int radius) {
            this.listenerSource = positionSource;
            this.listenerRadius = radius;
        }

        public PositionSource m_142460_() {
            return this.listenerSource;
        }

        public int m_142078_() {
            return this.listenerRadius;
        }

        public boolean m_214068_(ServerLevel level, GameEvent gameEvent, GameEvent.Context context, Vec3 pos) {
            if (gameEvent == GameEvent.f_238690_) {
                FleshBlob.this.setJukeboxPlaying(BlockPos.m_274446_((Position)pos), true);
                return true;
            }
            if (gameEvent == GameEvent.f_238649_) {
                FleshBlob.this.setJukeboxPlaying(BlockPos.m_274446_((Position)pos), false);
                return true;
            }
            return false;
        }
    }
}

