/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.entity.projectile;

import com.github.elenterius.biomancy.block.veins.FleshVeinsBlock;
import com.github.elenterius.biomancy.entity.projectile.BaseProjectile;
import com.github.elenterius.biomancy.entity.projectile.CorrosiveAcidProjectile;
import com.github.elenterius.biomancy.init.ModBlocks;
import com.github.elenterius.biomancy.init.ModEntityTypes;
import com.github.elenterius.biomancy.init.ModFluids;
import com.github.elenterius.biomancy.init.ModParticleTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class AcidBlobProjectile
extends CorrosiveAcidProjectile
implements GeoEntity {
    protected final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    protected boolean canPlaceAcidFluid = true;

    public AcidBlobProjectile(EntityType<? extends BaseProjectile> entityType, Level level) {
        super(entityType, level);
    }

    public AcidBlobProjectile(Level level, double x, double y, double z) {
        super((EntityType<? extends CorrosiveAcidProjectile>)((EntityType)ModEntityTypes.ACID_BLOB_PROJECTILE.get()), level, x, y, z);
    }

    public AcidBlobProjectile(Level level, double x, double y, double z, boolean canPlaceAcidFluid) {
        super((EntityType<? extends CorrosiveAcidProjectile>)((EntityType)ModEntityTypes.ACID_BLOB_PROJECTILE.get()), level, x, y, z);
        this.canPlaceAcidFluid = canPlaceAcidFluid;
    }

    public void setCanPlaceAcidFluid(boolean flag) {
        this.canPlaceAcidFluid = flag;
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.canPlaceAcidFluid = tag.m_128471_("place_acid_fluid");
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("place_acid_fluid", this.canPlaceAcidFluid);
    }

    @Override
    protected void m_8060_(BlockHitResult result) {
        if (this.canPlaceAcidFluid && this.placeAcidFluid(result)) {
            return;
        }
        super.m_8060_(result);
    }

    private boolean placeAcidFluid(BlockHitResult result) {
        BlockPos pos = result.m_82425_();
        BlockPos posRelative = pos.m_121945_(result.m_82434_());
        BlockState stateRelative = this.m_9236_().m_8055_(posRelative);
        if (stateRelative.m_60722_((Fluid)ModFluids.ACID.get())) {
            BlockState stateBelow = this.m_9236_().m_8055_(posRelative.m_7495_());
            if (stateBelow.m_60713_((Block)ModBlocks.ACID_FLUID_BLOCK.get()) || stateBelow.m_60783_((BlockGetter)this.m_9236_(), posRelative.m_7495_(), Direction.UP)) {
                if (!this.m_9236_().f_46443_) {
                    this.m_9236_().m_7731_(posRelative, ((LiquidBlock)ModBlocks.ACID_FLUID_BLOCK.get()).m_49966_(), 2);
                }
                this.playHitSound();
                return true;
            }
            if (stateRelative.m_60734_() instanceof FleshVeinsBlock) {
                if (!this.m_9236_().f_46443_) {
                    this.m_9236_().m_7731_(posRelative, Blocks.f_50016_.m_49966_(), 2);
                }
                this.playHitSound();
                return true;
            }
        }
        return false;
    }

    @Override
    protected ParticleOptions getParticle() {
        return (ParticleOptions)ModParticleTypes.FALLING_ACID.get();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

