/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.entity.projectile;

import com.github.elenterius.biomancy.entity.projectile.BaseProjectile;
import com.github.elenterius.biomancy.init.ModEntityTypes;
import com.github.elenterius.biomancy.world.PrimordialEcosystem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class BloomberryProjectile
extends BaseProjectile
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public BloomberryProjectile(EntityType<? extends BloomberryProjectile> entityType, Level level) {
        super(entityType, level);
    }

    public BloomberryProjectile(Level level, double x, double y, double z) {
        super((EntityType<? extends BaseProjectile>)((EntityType)ModEntityTypes.BLOOMBERRY_PROJECTILE.get()), level, x, y, z);
    }

    @Override
    public float getGravity() {
        return 0.025f;
    }

    @Override
    public boolean m_6087_() {
        return false;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        return false;
    }

    protected void m_8060_(BlockHitResult result) {
        super.m_8060_(result);
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Direction direction = result.m_82434_();
            PrimordialEcosystem.placeBloomOrBlocks(serverLevel, result.m_82425_(), direction);
        }
        this.m_5496_(SoundEvents.f_12389_, 1.0f, 1.2f / (this.f_19796_.m_188501_() * 0.2f + 0.9f));
    }

    protected void m_5790_(EntityHitResult result) {
        super.m_5790_(result);
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Direction direction = Direction.m_122382_((Entity)this)[0];
            BlockPos pos = BlockPos.m_274446_((Position)result.m_82450_());
            PrimordialEcosystem.placeBloomOrBlocks(serverLevel, pos, direction);
        }
        this.m_5496_(SoundEvents.f_12389_, 1.0f, 1.2f / (this.f_19796_.m_188501_() * 0.2f + 0.9f));
    }

    @Override
    protected ParticleOptions getParticle() {
        return ParticleTypes.f_123764_;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

