/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.event;

import com.github.elenterius.biomancy.init.ModCapabilities;
import com.github.elenterius.biomancy.item.CriticalHitListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="biomancy", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class AttackHandler {
    private AttackHandler() {
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onCriticalHit(CriticalHitEvent event) {
        Entity entity;
        if (event.getDamageModifier() > 0.0f && (entity = event.getTarget()) instanceof LivingEntity) {
            ItemStack heldStack;
            Item item;
            LivingEntity target = (LivingEntity)entity;
            if ((event.getResult() == Event.Result.ALLOW || event.isVanillaCritical() && event.getResult() == Event.Result.DEFAULT) && (item = (heldStack = event.getEntity().m_21205_()).m_41720_()) instanceof CriticalHitListener) {
                CriticalHitListener listener = (CriticalHitListener)item;
                listener.onCriticalHitEntity(heldStack, (LivingEntity)event.getEntity(), target);
            }
        }
    }

    @Deprecated(forRemoval=true)
    @SubscribeEvent(receiveCanceled=false)
    public static void onKnockback(LivingKnockBackEvent event) {
        event.getEntity().getCapability(ModCapabilities.NO_KNOCKBACK_FLAG_CAP).ifPresent(flag -> {
            if (flag.isEnabled()) {
                flag.disable();
                event.setCanceled(true);
            }
        });
    }
}

