/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.fluid;

import com.github.elenterius.biomancy.block.veins.FleshVeinsBlock;
import com.github.elenterius.biomancy.init.ModFluids;
import com.github.elenterius.biomancy.init.tags.ModBlockTags;
import com.github.elenterius.biomancy.util.CombatUtil;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.ForgeFlowingFluid;

public abstract class AcidFluid
extends ForgeFlowingFluid {
    protected static final Map<Block, BlockState> NORMAL_TO_ERODED_BLOCK_CONVERSION = Map.of(Blocks.f_50440_, Blocks.f_50493_.m_49966_(), Blocks.f_50652_, Blocks.f_49994_.m_49966_(), Blocks.f_50222_, Blocks.f_50224_.m_49966_(), Blocks.f_152589_, Blocks.f_152594_.m_49966_(), Blocks.f_152559_, Blocks.f_152595_.m_49966_(), Blocks.f_50735_, Blocks.f_50736_.m_49966_(), Blocks.f_50197_, Blocks.f_50713_.m_49966_());

    protected AcidFluid(ForgeFlowingFluid.Properties properties) {
        super(properties);
    }

    public static void onEntityInside(LivingEntity livingEntity) {
        if (livingEntity.m_5833_()) {
            return;
        }
        if (livingEntity.f_19797_ % 5 != 0) {
            return;
        }
        if (!livingEntity.isInFluidType((FluidType)ModFluids.ACID_TYPE.get())) {
            return;
        }
        if (!livingEntity.m_9236_().f_46443_) {
            CombatUtil.applyAcidEffect(livingEntity, 4);
        } else if (livingEntity.f_19797_ % 10 == 0 && livingEntity.m_217043_().m_188501_() < 0.4f) {
            Level level = livingEntity.m_9236_();
            RandomSource random = livingEntity.m_217043_();
            Vec3 pos = livingEntity.m_20182_();
            double height = livingEntity.m_20191_().m_82376_() * 0.5;
            level.m_7785_(pos.f_82479_, pos.f_82480_, pos.f_82481_, SoundEvents.f_12031_, SoundSource.BLOCKS, 0.5f, 2.6f + (random.m_188501_() - random.m_188501_()) * 0.8f, false);
            for (int i = 0; i < 4; ++i) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123755_, pos.f_82479_ + random.m_188500_(), pos.f_82480_ + random.m_188500_() * height, pos.f_82481_ + random.m_188500_(), 0.0, 0.1, 0.0);
            }
        }
    }

    protected boolean m_75963_(BlockGetter level, Fluid fluid, BlockPos fromPos, BlockState fromBlockState, Direction direction, BlockPos toPos, BlockState toBlockState, FluidState toFluidState) {
        return toBlockState.m_60734_() instanceof FleshVeinsBlock || super.m_75963_(level, fluid, fromPos, fromBlockState, direction, toPos, toBlockState, toFluidState);
    }

    protected boolean m_75977_(BlockGetter level, BlockPos fromPos, BlockState fromBlockState, Direction direction, BlockPos toPos, BlockState toBlockState, FluidState toFluidState, Fluid fluid) {
        return toBlockState.m_60734_() instanceof FleshVeinsBlock || super.m_75977_(level, fromPos, fromBlockState, direction, toPos, toBlockState, toFluidState, fluid);
    }

    protected void m_6364_(LevelAccessor level, BlockPos pos, BlockState state, Direction direction, FluidState fluidState) {
        if (state.m_60734_() instanceof FleshVeinsBlock) {
            this.m_7456_(level, pos, state);
            level.m_7731_(pos, fluidState.m_76188_(), 3);
            return;
        }
        super.m_6364_(level, pos, state, direction, fluidState);
    }

    protected void m_7456_(LevelAccessor level, BlockPos pos, BlockState state) {
        if (state.m_204336_(ModBlockTags.ACID_DESTRUCTIBLE)) {
            return;
        }
        super.m_7456_(level, pos, state);
    }

    protected boolean m_6685_() {
        return true;
    }

    protected void m_213812_(Level level, BlockPos liquidPos, FluidState fluidState, RandomSource random) {
        if (level.f_46441_.m_188501_() > 0.4f) {
            return;
        }
        for (int i = 0; i < 3; ++i) {
            Block block;
            float p = level.f_46441_.m_188501_();
            int yOffset = 0;
            if (p < 0.2f) {
                yOffset = 1;
            } else if (p < 0.6f) {
                yOffset = -1;
            }
            BlockPos blockPos = liquidPos.m_7918_(random.m_188503_(3) - 1, yOffset, random.m_188503_(3) - 1);
            if (!level.m_46749_(blockPos)) {
                return;
            }
            BlockState blockState = level.m_8055_(blockPos);
            if (blockState.m_60795_()) {
                return;
            }
            if (level.f_46441_.m_188501_() >= 0.1f) {
                block = blockState.m_60734_();
                if (this.corrodeCopper(level, liquidPos, block, blockState, blockPos) || this.destroyBlock(level, liquidPos, block, blockState, blockPos) || this.erodeBlock(level, liquidPos, block, blockState, blockPos) || fluidState.m_76186_() <= 2) continue;
                this.destroyFleshVeins(level, liquidPos, block, blockState, blockPos);
                continue;
            }
            if (fluidState.m_76186_() <= 2) continue;
            block = blockState.m_60734_();
            this.destroyFleshVeins(level, liquidPos, block, blockState, blockPos);
        }
    }

    protected boolean corrodeCopper(Level level, BlockPos liquidPos, Block block, BlockState blockState, BlockPos pos) {
        if (block instanceof WeatheringCopper) {
            WeatheringCopper weatheringCopper = (WeatheringCopper)block;
            if (WeatheringCopper.m_154904_((Block)block).isPresent()) {
                weatheringCopper.m_142123_(blockState).ifPresent(state -> level.m_46597_(pos, ForgeEventFactory.fireFluidPlaceBlockEvent((LevelAccessor)level, (BlockPos)pos, (BlockPos)liquidPos, (BlockState)state)));
                level.m_46796_(1501, pos, 0);
                return true;
            }
        }
        return false;
    }

    protected boolean destroyBlock(Level level, BlockPos liquidPos, Block block, BlockState blockState, BlockPos pos) {
        if (!blockState.m_204336_(ModBlockTags.ACID_DESTRUCTIBLE)) {
            return false;
        }
        SoundType soundType = block.getSoundType(blockState, (LevelReader)level, pos, null);
        level.m_46597_(pos, ForgeEventFactory.fireFluidPlaceBlockEvent((LevelAccessor)level, (BlockPos)pos, (BlockPos)liquidPos, (BlockState)Blocks.f_50016_.m_49966_()));
        level.m_5594_(null, pos, soundType.m_56775_(), SoundSource.BLOCKS, soundType.f_56731_, soundType.f_56732_);
        level.m_46796_(1501, pos, 0);
        return true;
    }

    protected boolean erodeBlock(Level level, BlockPos liquidPos, Block block, BlockState blockState, BlockPos pos) {
        if (!NORMAL_TO_ERODED_BLOCK_CONVERSION.containsKey(block)) {
            return false;
        }
        SoundType soundType = block.getSoundType(blockState, (LevelReader)level, pos, null);
        level.m_46597_(pos, ForgeEventFactory.fireFluidPlaceBlockEvent((LevelAccessor)level, (BlockPos)pos, (BlockPos)liquidPos, (BlockState)NORMAL_TO_ERODED_BLOCK_CONVERSION.get(block)));
        level.m_5594_(null, pos, soundType.m_56775_(), SoundSource.BLOCKS, soundType.f_56731_, soundType.f_56732_);
        level.m_46796_(1501, pos, 0);
        return true;
    }

    protected void destroyFleshVeins(Level level, BlockPos liquidPos, Block block, BlockState blockState, BlockPos pos) {
        if (block instanceof FleshVeinsBlock) {
            level.m_46597_(pos, ForgeEventFactory.fireFluidPlaceBlockEvent((LevelAccessor)level, (BlockPos)pos, (BlockPos)liquidPos, (BlockState)Blocks.f_50016_.m_49966_()));
            level.m_46796_(1501, pos, 0);
        }
    }

    protected void m_213811_(Level level, BlockPos pos, FluidState state, RandomSource random) {
        if (!state.m_76170_() && Boolean.FALSE.equals(state.m_61143_((Property)f_75947_))) {
            if (random.m_188503_(64) == 0) {
                level.m_7785_((double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.5f), (double)((float)pos.m_123343_() + 0.5f), SoundEvents.f_12540_, SoundSource.BLOCKS, random.m_188501_() * 0.25f + 0.75f, random.m_188501_() + 0.5f, false);
            }
        } else if (random.m_188503_(10) == 0) {
            level.m_7106_((ParticleOptions)ParticleTypes.f_123768_, (double)pos.m_123341_() + random.m_188500_(), (double)pos.m_123342_() + random.m_188500_(), (double)pos.m_123343_() + random.m_188500_(), 0.0, 0.0, 0.0);
        }
    }

    public static class Source
    extends AcidFluid {
        public Source(ForgeFlowingFluid.Properties properties) {
            super(properties);
        }

        public int m_7430_(FluidState state) {
            return 8;
        }

        public boolean m_7444_(FluidState state) {
            return true;
        }
    }

    public static class Flowing
    extends AcidFluid {
        public Flowing(ForgeFlowingFluid.Properties properties) {
            super(properties);
            this.m_76142_((FluidState)((FluidState)this.m_76144_().m_61090_()).m_61124_((Property)f_75948_, (Comparable)Integer.valueOf(7)));
        }

        protected void m_7180_(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.m_7180_(builder);
            builder.m_61104_(new Property[]{f_75948_});
        }

        public int m_7430_(FluidState state) {
            return (Integer)state.m_61143_((Property)f_75948_);
        }

        public boolean m_7444_(FluidState state) {
            return false;
        }
    }
}

