/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.fluid;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.function.Consumer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class TintedFluidType
extends FluidType {
    protected static final ResourceLocation STILL_TEXTURE = new ResourceLocation("block/water_still");
    protected static final ResourceLocation FLOWING_TEXTURE = new ResourceLocation("block/water_flow");
    protected static final ResourceLocation OVERLAY_TEXTURE = new ResourceLocation("block/water_overlay");
    protected static final ResourceLocation INSIDE_FLUID_TEXTURE = new ResourceLocation("textures/block/water_overlay.png");
    protected final int colorARGB;

    public TintedFluidType(FluidType.Properties properties, int colorARGB) {
        super(properties);
        this.colorARGB = colorARGB;
    }

    public static void renderTintedScreenOverlay(Minecraft minecraft, PoseStack poseStack, ResourceLocation texture, int colorARGB) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        LocalPlayer player = minecraft.f_91074_;
        BlockPos blockPos = BlockPos.m_274561_((double)player.m_20185_(), (double)player.m_20188_(), (double)player.m_20189_());
        float brightness = LightTexture.m_234316_((DimensionType)player.m_9236_().m_6042_(), (int)player.m_9236_().m_46803_(blockPos));
        float red = (float)FastColor.ARGB32.m_13665_((int)colorARGB) / 255.0f * brightness;
        float green = (float)FastColor.ARGB32.m_13667_((int)colorARGB) / 255.0f * brightness;
        float blue = (float)FastColor.ARGB32.m_13669_((int)colorARGB) / 255.0f * brightness;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)0.5f);
        float uOffset = -player.m_146908_() / 64.0f;
        float vOffset = player.m_146909_() / 64.0f;
        float depth = -0.5f;
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferbuilder.m_252986_(matrix4f, -1.0f, -1.0f, depth).m_7421_(4.0f + uOffset, 4.0f + vOffset).m_5752_();
        bufferbuilder.m_252986_(matrix4f, 1.0f, -1.0f, depth).m_7421_(uOffset, 4.0f + vOffset).m_5752_();
        bufferbuilder.m_252986_(matrix4f, 1.0f, 1.0f, depth).m_7421_(uOffset, vOffset).m_5752_();
        bufferbuilder.m_252986_(matrix4f, -1.0f, 1.0f, depth).m_7421_(4.0f + uOffset, vOffset).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }

    public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
        consumer.accept(new IClientFluidTypeExtensions(){

            public int getTintColor() {
                return TintedFluidType.this.colorARGB;
            }

            @NotNull
            public Vector3f modifyFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount, Vector3f fluidFogColor) {
                float red = (float)FastColor.ARGB32.m_13665_((int)TintedFluidType.this.colorARGB) / 255.0f * fluidFogColor.x();
                float green = (float)FastColor.ARGB32.m_13667_((int)TintedFluidType.this.colorARGB) / 255.0f * fluidFogColor.y();
                float blue = (float)FastColor.ARGB32.m_13669_((int)TintedFluidType.this.colorARGB) / 255.0f * fluidFogColor.z();
                fluidFogColor.set(red, green, blue);
                return fluidFogColor;
            }

            public ResourceLocation getStillTexture() {
                return STILL_TEXTURE;
            }

            public ResourceLocation getFlowingTexture() {
                return FLOWING_TEXTURE;
            }

            public ResourceLocation getOverlayTexture() {
                return OVERLAY_TEXTURE;
            }

            public ResourceLocation getRenderOverlayTexture(Minecraft mc) {
                return INSIDE_FLUID_TEXTURE;
            }

            public void renderOverlay(Minecraft mc, PoseStack poseStack) {
                TintedFluidType.renderTintedScreenOverlay(mc, poseStack, INSIDE_FLUID_TEXTURE, TintedFluidType.this.colorARGB);
            }
        });
    }
}

