/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.init;

import com.github.elenterius.biomancy.entity.projectile.BaseProjectile;
import com.github.elenterius.biomancy.init.ModDamageTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public final class ModDamageSources {
    private ModDamageSources() {
    }

    public static DamageSource fallOnSpike(Level level, BlockPos pos) {
        return ModDamageSources.source(ModDamageTypes.FALL_ON_SPIKE, (LevelReader)level, Vec3.m_82512_((Vec3i)pos));
    }

    public static DamageSource impaleBySpike(Level level, BlockPos pos) {
        return ModDamageSources.source(ModDamageTypes.IMPALED_BY_SPIKE, (LevelReader)level, Vec3.m_82512_((Vec3i)pos));
    }

    public static DamageSource chestBite(Level level, BlockPos pos) {
        return ModDamageSources.source(ModDamageTypes.CHEST_BITE, (LevelReader)level, Vec3.m_82512_((Vec3i)pos));
    }

    public static DamageSource primalSpikes(Level level, Vec3 pos) {
        return ModDamageSources.source(ModDamageTypes.PRIMORDIAL_SPIKES, (LevelReader)level, pos);
    }

    public static DamageSource acid(Level level, @Nullable Entity attacker) {
        return ModDamageSources.source(ModDamageTypes.CORROSIVE_ACID, (LevelReader)level, attacker);
    }

    public static DamageSource bleed(Level level, @Nullable Entity attacker) {
        return ModDamageSources.source(ModDamageTypes.BLEED, (LevelReader)level, attacker);
    }

    public static DamageSource toothProjectile(Level level, BaseProjectile projectile, @Nullable Entity shooter) {
        return ModDamageSources.source(ModDamageTypes.TOOTH_PROJECTILE, (LevelReader)level, (Entity)projectile, shooter);
    }

    public static DamageSource acidProjectile(Level level, BaseProjectile projectile, @Nullable Entity shooter) {
        return ModDamageSources.source(ModDamageTypes.CORROSIVE_ACID, (LevelReader)level, (Entity)projectile, shooter);
    }

    public static DamageSource projectile(Holder<DamageType> type, BaseProjectile projectile, @Nullable Entity shooter) {
        return new DamageSource(type, (Entity)projectile, shooter);
    }

    private static DamageSource source(ResourceKey<DamageType> key, LevelReader level) {
        return new DamageSource(ModDamageTypes.getHolder(key, level));
    }

    private static DamageSource source(ResourceKey<DamageType> key, LevelReader level, BlockPos pos) {
        return ModDamageSources.source(key, level, Vec3.m_82512_((Vec3i)pos));
    }

    private static DamageSource source(ResourceKey<DamageType> key, LevelReader level, Vec3 pos) {
        return new DamageSource(ModDamageTypes.getHolder(key, level), pos);
    }

    private static DamageSource source(ResourceKey<DamageType> key, LevelReader level, @Nullable Entity entity) {
        return new DamageSource(ModDamageTypes.getHolder(key, level), entity);
    }

    private static DamageSource source(ResourceKey<DamageType> key, LevelReader level, @Nullable Entity directEntity, @Nullable Entity causingEntity) {
        return new DamageSource(ModDamageTypes.getHolder(key, level), directEntity, causingEntity);
    }
}

