/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.init;

import com.github.elenterius.biomancy.entity.projectile.AcidBlobProjectile;
import com.github.elenterius.biomancy.entity.projectile.BaseProjectile;
import com.github.elenterius.biomancy.entity.projectile.BloomberryProjectile;
import com.github.elenterius.biomancy.entity.projectile.ToothProjectile;
import com.github.elenterius.biomancy.util.function.FloatOperator;
import com.github.elenterius.biomancy.util.function.IntOperator;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public final class ModProjectiles {
    public static final List<ConfiguredProjectile<? extends BaseProjectile>> PRECONFIGURED_PROJECTILES = new ArrayList<ConfiguredProjectile<? extends BaseProjectile>>();
    public static final ConfiguredProjectile<ToothProjectile> TOOTH = ModProjectiles.build("Sharp Tooth", 1.75f, 5.0f, 0, ModProjectiles.convertToInaccuracy(0.92f), ToothProjectile::new);
    public static final ConfiguredProjectile<AcidBlobProjectile> ACID_BLOB = ModProjectiles.build("Acid Blob", 1.2f, 2.0f, 0, ModProjectiles.convertToInaccuracy(0.9f), SoundEvents.f_12469_, (level, x, y, z) -> new AcidBlobProjectile(level, x, y, z, false));
    public static final ConfiguredProjectile<AcidBlobProjectile> FALLING_ACID_BLOB = ModProjectiles.build("Falling Acid Blob", 0.1f, 2.0f, 0, ModProjectiles.convertToInaccuracy(0.9f), SoundEvents.f_12470_, AcidBlobProjectile::new);
    public static final ConfiguredProjectile<BloomberryProjectile> BLOOMBERRY = ModProjectiles.build("Bloomberry", 1.25f, 2.0f, 0, ModProjectiles.convertToInaccuracy(0.9f), BloomberryProjectile::new);

    private static float convertToInaccuracy(float accuracy) {
        return -1.0f * accuracy + 1.0f;
    }

    private static <T extends BaseProjectile> ConfiguredProjectile<T> build(String name, float velocity, float damage, int knockback, float accuracy, ProjectileFactory<T> factory) {
        ConfiguredProjectile<T> configuredProjectile = new ConfiguredProjectile<T>(name, velocity, damage, knockback, ModProjectiles.convertToInaccuracy(accuracy), SoundEvents.f_11847_, factory);
        PRECONFIGURED_PROJECTILES.add(configuredProjectile);
        return configuredProjectile;
    }

    private static <T extends BaseProjectile> ConfiguredProjectile<T> build(String name, float velocity, float damage, int knockback, float accuracy, SoundEvent shootSound, ProjectileFactory<T> factory) {
        ConfiguredProjectile<T> configuredProjectile = new ConfiguredProjectile<T>(name, velocity, damage, knockback, ModProjectiles.convertToInaccuracy(accuracy), shootSound, factory);
        PRECONFIGURED_PROJECTILES.add(configuredProjectile);
        return configuredProjectile;
    }

    public static <T extends BaseProjectile> boolean shootProjectile(Level level, LivingEntity shooter, float velocity, float damage, int knockback, float inaccuracy, SoundEvent shootSound, ProjectileFactory<T> factory) {
        T projectile = factory.create(level, shooter.m_20185_(), shooter.m_20188_() - (double)0.1f, shooter.m_20189_());
        projectile.m_5602_((Entity)shooter);
        ((BaseProjectile)((Object)projectile)).setDamage(damage);
        if (knockback > 0) {
            ((BaseProjectile)((Object)projectile)).setKnockback((byte)knockback);
        }
        Vec3 direction = shooter.m_20154_();
        ((BaseProjectile)((Object)projectile)).m_6686_(direction.m_7096_(), direction.m_7098_(), direction.m_7094_(), velocity, inaccuracy);
        if (level.m_7967_(projectile)) {
            level.m_6263_(null, shooter.m_20185_(), shooter.m_20186_(), shooter.m_20189_(), shootSound, SoundSource.PLAYERS, 0.8f, 0.4f);
            return true;
        }
        return false;
    }

    public static <T extends BaseProjectile> boolean shootProjectile(Level level, Vec3 origin, Vec3 target, float velocity, float damage, int knockback, float inaccuracy, SoundEvent shootSound, ProjectileFactory<T> factory) {
        T projectile = factory.create(level, origin.f_82479_, origin.f_82480_, origin.f_82481_);
        ((BaseProjectile)((Object)projectile)).setDamage(damage);
        if (knockback > 0) {
            ((BaseProjectile)((Object)projectile)).setKnockback((byte)knockback);
        }
        Vec3 direction = target.m_82546_(origin).m_82541_();
        ((BaseProjectile)((Object)projectile)).m_6686_(direction.m_7096_(), direction.m_7098_(), direction.m_7094_(), velocity, inaccuracy);
        if (level.m_7967_(projectile)) {
            level.m_6263_(null, origin.f_82479_, origin.f_82480_, origin.f_82481_, shootSound, SoundSource.PLAYERS, 0.8f, 0.4f);
            return true;
        }
        return false;
    }

    public record ConfiguredProjectile<T extends BaseProjectile>(String name, float velocity, float damage, int knockback, float inaccuracy, SoundEvent shootSound, ProjectileFactory<T> factory) {
        public boolean shoot(Level level, Vec3 origin, Vec3 target) {
            return ModProjectiles.shootProjectile(level, origin, target, this.velocity, this.damage, this.knockback, this.inaccuracy, this.shootSound, this.factory);
        }

        public boolean shoot(Level level, Vec3 origin, Vec3 target, FloatOperator velocityModifier, FloatOperator damageModifier, IntOperator knockbackModifier, FloatOperator inaccuracyModifier) {
            return ModProjectiles.shootProjectile(level, origin, target, velocityModifier.apply(this.velocity), damageModifier.apply(this.damage), knockbackModifier.apply(this.knockback), inaccuracyModifier.apply(this.inaccuracy), this.shootSound, this.factory);
        }

        public boolean shoot(Level level, LivingEntity shooter) {
            return ModProjectiles.shootProjectile(level, shooter, this.velocity, this.damage, this.knockback, this.inaccuracy, this.shootSound, this.factory);
        }

        public boolean shoot(Level level, LivingEntity shooter, FloatOperator velocityModifier, FloatOperator damageModifier, IntOperator knockbackModifier, FloatOperator inaccuracyModifier) {
            return ModProjectiles.shootProjectile(level, shooter, velocityModifier.apply(this.velocity), damageModifier.apply(this.damage), knockbackModifier.apply(this.knockback), inaccuracyModifier.apply(this.inaccuracy), this.shootSound, this.factory);
        }
    }

    public static interface ProjectileFactory<T extends BaseProjectile> {
        public T create(Level var1, double var2, double var4, double var6);
    }
}

