/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.init;

import com.github.elenterius.biomancy.BiomancyConfig;
import com.github.elenterius.biomancy.init.ModItems;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Arrays;
import java.util.List;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.BasicItemListing;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.event.village.WandererTradesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="biomancy")
public class ModVillagerTrades {
    @SubscribeEvent
    public static void onVillagerTrades(VillagerTradesEvent event) {
        if (Boolean.FALSE.equals(BiomancyConfig.SERVER.addTradesToVillagers.get())) {
            return;
        }
        if (event.getType() == VillagerProfession.f_35587_) {
            ModVillagerTrades.addButcherTrades((Int2ObjectMap<List<VillagerTrades.ItemListing>>)event.getTrades());
        } else if (event.getType() == VillagerProfession.f_35589_) {
            ModVillagerTrades.addClericTrades((Int2ObjectMap<List<VillagerTrades.ItemListing>>)event.getTrades());
        }
    }

    @SubscribeEvent
    public static void onWandererTrades(WandererTradesEvent event) {
        if (Boolean.FALSE.equals(BiomancyConfig.SERVER.addTradesToWanderingTrader.get())) {
            return;
        }
        List genericTrades = event.getGenericTrades();
        genericTrades.add(ModVillagerTrades.sellToPlayer((Item)ModItems.EXOTIC_DUST.get(), 4, 2, 16, 5));
        genericTrades.add(ModVillagerTrades.sellToPlayer((Item)ModItems.FLESH_SPIKE.get(), 2, 16, 5));
        genericTrades.add(ModVillagerTrades.buyFromPlayer((Item)ModItems.NUTRIENT_BAR.get(), 2, 8, 5));
        List rareTrades = event.getRareTrades();
        rareTrades.add(ModVillagerTrades.sellToPlayer((Item)ModItems.INSOMNIA_CURE.get(), 10, 8, 20));
        rareTrades.add(ModVillagerTrades.sellToPlayer((Item)ModItems.CREATOR_MIX.get(), 10, 5, 20));
    }

    private static BasicItemListing buyFromPlayer(Item item, int emeralds, int maxTrades, int xp) {
        return new BasicItemListing(new ItemStack((ItemLike)item), new ItemStack((ItemLike)Items.f_42616_, emeralds), maxTrades, xp, 0.05f);
    }

    private static BasicItemListing buyFromPlayer(Item item, int amount, int emeralds, int maxTrades, int xp) {
        return new BasicItemListing(new ItemStack((ItemLike)item, amount), new ItemStack((ItemLike)Items.f_42616_, emeralds), maxTrades, xp, 0.05f);
    }

    private static BasicItemListing convertItem(Item item, int emeralds, Item result, int resultAmount, int maxTrades, int xp) {
        return new BasicItemListing(new ItemStack((ItemLike)item), new ItemStack((ItemLike)Items.f_42616_, emeralds), new ItemStack((ItemLike)result, resultAmount), maxTrades, xp, 0.05f);
    }

    private static BasicItemListing convertItem(Item item, int emeralds, Item result, int maxTrades, int xp) {
        return new BasicItemListing(new ItemStack((ItemLike)item), new ItemStack((ItemLike)Items.f_42616_, emeralds), new ItemStack((ItemLike)result), maxTrades, xp, 0.05f);
    }

    private static BasicItemListing sellToPlayer(Item item, int emeralds, int maxTrades, int xp) {
        return new BasicItemListing(emeralds, new ItemStack((ItemLike)item), maxTrades, xp, 0.05f);
    }

    private static BasicItemListing sellToPlayer(Item item, int amount, int emeralds, int maxTrades, int xp) {
        return new BasicItemListing(emeralds, new ItemStack((ItemLike)item, amount), maxTrades, xp, 0.05f);
    }

    private static void addClericTrades(Int2ObjectMap<List<VillagerTrades.ItemListing>> trades) {
        TradeLevel.JOURNEYMAN.addItemListings(trades, ModVillagerTrades.buyFromPlayer((Item)ModItems.VIAL.get(), 4, 1, 12, 20));
        TradeLevel.EXPERT.addItemListings(trades, ModVillagerTrades.buyFromPlayer((Item)ModItems.BILE.get(), 2, 12, 30));
        TradeLevel.MASTER.addItemListings(trades, ModVillagerTrades.convertItem((Item)ModItems.TOXIN_GLAND.get(), 4, (Item)ModItems.TOXIN_EXTRACT.get(), 4, 8, 15));
    }

    private static void addButcherTrades(Int2ObjectMap<List<VillagerTrades.ItemListing>> trades) {
        TradeLevel.NOVICE.addItemListings(trades, ModVillagerTrades.sellToPlayer((Item)ModItems.MOB_FANG.get(), 12, 16, 2), ModVillagerTrades.sellToPlayer((Item)ModItems.MOB_CLAW.get(), 10, 16, 2));
        TradeLevel.APPRENTICE.addItemListings(trades, ModVillagerTrades.buyFromPlayer((Item)ModItems.MOB_SINEW.get(), 4, 1, 8, 5), ModVillagerTrades.buyFromPlayer((Item)ModItems.GENERIC_MOB_GLAND.get(), 2, 1, 8, 5));
        TradeLevel.JOURNEYMAN.addItemListings(trades, ModVillagerTrades.buyFromPlayer((Item)ModItems.MOB_MARROW.get(), 4, 1, 12, 20));
        TradeLevel.EXPERT.addItemListings(trades, ModVillagerTrades.sellToPlayer((Item)ModItems.FLESH_BITS.get(), 2, 12, 30), ModVillagerTrades.sellToPlayer((Item)ModItems.BONE_FRAGMENTS.get(), 2, 12, 30));
        TradeLevel.MASTER.addItemListings(trades, ModVillagerTrades.sellToPlayer((Item)ModItems.WITHERED_MOB_MARROW.get(), 20, 8, 30), ModVillagerTrades.convertItem((Item)ModItems.VOLATILE_GLAND.get(), 4, Items.f_42403_, 4, 8, 15));
    }

    static enum TradeLevel {
        NOVICE,
        APPRENTICE,
        JOURNEYMAN,
        EXPERT,
        MASTER;


        List<VillagerTrades.ItemListing> getItemListings(Int2ObjectMap<List<VillagerTrades.ItemListing>> trades) {
            return (List)trades.get(this.ordinal() + 1);
        }

        void addItemListings(Int2ObjectMap<List<VillagerTrades.ItemListing>> trades, BasicItemListing ... listings) {
            this.getItemListings(trades).addAll(Arrays.asList(listings));
        }
    }
}

