/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.init.client;

import com.github.elenterius.biomancy.block.membrane.BiometricMembraneBlock;
import com.github.elenterius.biomancy.block.vialholder.VialHolderBlock;
import com.github.elenterius.biomancy.client.gui.IngameOverlays;
import com.github.elenterius.biomancy.client.gui.tooltip.EmptyLineClientComponent;
import com.github.elenterius.biomancy.client.gui.tooltip.HrTooltipClientComponent;
import com.github.elenterius.biomancy.client.gui.tooltip.StorageSacTooltipClientComponent;
import com.github.elenterius.biomancy.client.particle.BloodDripParticle;
import com.github.elenterius.biomancy.client.particle.ParticleProviders;
import com.github.elenterius.biomancy.client.render.block.bioforge.BioForgeRenderer;
import com.github.elenterius.biomancy.client.render.block.biolab.BioLabRenderer;
import com.github.elenterius.biomancy.client.render.block.cradle.PrimordialCradleRenderer;
import com.github.elenterius.biomancy.client.render.block.decomposer.DecomposerRenderer;
import com.github.elenterius.biomancy.client.render.block.digester.DigesterRenderer;
import com.github.elenterius.biomancy.client.render.block.fleshkinchest.FleshkinChestRenderer;
import com.github.elenterius.biomancy.client.render.block.mawhopper.MawHopperRenderer;
import com.github.elenterius.biomancy.client.render.block.storagesac.StorageSacRenderer;
import com.github.elenterius.biomancy.client.render.block.tongue.TongueRenderer;
import com.github.elenterius.biomancy.client.render.entity.mob.fleshblob.FleshBlobRenderer;
import com.github.elenterius.biomancy.client.render.entity.mob.fleshblob.LegacyFleshBlobRenderer;
import com.github.elenterius.biomancy.client.render.entity.mob.fleshblob.PrimordialFleshBlobRenderer;
import com.github.elenterius.biomancy.client.render.entity.projectile.AcidProjectileRenderer;
import com.github.elenterius.biomancy.client.render.entity.projectile.acidblob.AcidBlobProjectileRenderer;
import com.github.elenterius.biomancy.client.render.entity.projectile.bloomberry.BloomberryProjectileRenderer;
import com.github.elenterius.biomancy.init.ModBlockEntities;
import com.github.elenterius.biomancy.init.ModBlocks;
import com.github.elenterius.biomancy.init.ModEntityTypes;
import com.github.elenterius.biomancy.init.ModFluids;
import com.github.elenterius.biomancy.init.ModItems;
import com.github.elenterius.biomancy.init.ModParticleTypes;
import com.github.elenterius.biomancy.init.client.ModScreens;
import com.github.elenterius.biomancy.integration.ModsCompatHandler;
import com.github.elenterius.biomancy.item.EssenceItem;
import com.github.elenterius.biomancy.item.weapon.gun.GunbladeItem;
import com.github.elenterius.biomancy.tooltip.EmptyLineTooltipComponent;
import com.github.elenterius.biomancy.tooltip.HrTooltipComponent;
import com.github.elenterius.biomancy.tooltip.StorageSacTooltipComponent;
import com.mojang.blaze3d.platform.InputConstants;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.particle.AttackSweepParticle;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(modid="biomancy", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public final class ClientSetupHandler {
    public static final KeyMapping ITEM_DEFAULT_KEY_BINDING = new KeyMapping(String.format("key.%s.item_default", "biomancy"), (IKeyConflictContext)KeyConflictContext.UNIVERSAL, InputConstants.Type.KEYSYM, 86, "key.categories.biomancy");

    private ClientSetupHandler() {
    }

    @SubscribeEvent
    public static void onSetup(FMLClientSetupEvent event) {
        ModScreens.registerMenuScreens();
        ClientSetupHandler.setBlockRenderLayers();
        event.enqueueWork(ClientSetupHandler::onPostSetup);
        ModsCompatHandler.onBiomancyClientSetup(event);
    }

    private static void onPostSetup() {
        ClientSetupHandler.registerItemModelProperties();
    }

    @SubscribeEvent
    public static void registerKeyMappings(RegisterKeyMappingsEvent event) {
        event.register(ITEM_DEFAULT_KEY_BINDING);
    }

    @SubscribeEvent
    public static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)ModBlockEntities.PRIMORDIAL_CRADLE.get(), PrimordialCradleRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)ModBlockEntities.DECOMPOSER.get(), DecomposerRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)ModBlockEntities.DIGESTER.get(), DigesterRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)ModBlockEntities.BIO_FORGE.get(), BioForgeRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)ModBlockEntities.BIO_LAB.get(), BioLabRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)ModBlockEntities.TONGUE.get(), TongueRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)ModBlockEntities.FLESHKIN_CHEST.get(), FleshkinChestRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)ModBlockEntities.STORAGE_SAC.get(), StorageSacRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)ModBlockEntities.MAW_HOPPER.get(), MawHopperRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntityTypes.HUNGRY_FLESH_BLOB.get(), FleshBlobRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntityTypes.FLESH_BLOB.get(), FleshBlobRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntityTypes.LEGACY_FLESH_BLOB.get(), LegacyFleshBlobRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntityTypes.PRIMORDIAL_FLESH_BLOB.get(), PrimordialFleshBlobRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntityTypes.PRIMORDIAL_HUNGRY_FLESH_BLOB.get(), PrimordialFleshBlobRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntityTypes.CORROSIVE_ACID_PROJECTILE.get(), AcidProjectileRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntityTypes.TOOTH_PROJECTILE.get(), ThrownItemRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntityTypes.BLOOMBERRY_PROJECTILE.get(), BloomberryProjectileRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntityTypes.ACID_BLOB_PROJECTILE.get(), AcidBlobProjectileRenderer::new);
    }

    private static void setBlockRenderLayers() {
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.FLESH_IRIS_DOOR.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.FLESH_DOOR.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.FULL_FLESH_DOOR.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)ModFluids.ACID.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)ModFluids.FLOWING_ACID.get()), (RenderType)RenderType.m_110466_());
    }

    @SubscribeEvent
    public static void registerParticles(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)ModParticleTypes.BLOODY_CLAWS_ATTACK.get(), AttackSweepParticle.Provider::new);
        event.registerSpriteSet((ParticleType)ModParticleTypes.FALLING_BLOOD.get(), BloodDripParticle.FallingBloodFactory::new);
        event.registerSpriteSet((ParticleType)ModParticleTypes.LANDING_BLOOD.get(), BloodDripParticle.LandingBloodFactory::new);
        event.registerSpriteSet((ParticleType)ModParticleTypes.CORROSIVE_SWIPE_ATTACK.get(), AttackSweepParticle.Provider::new);
        event.registerSpriteSet((ParticleType)ModParticleTypes.DRIPPING_ACID.get(), ParticleProviders.AcidHangProvider::new);
        event.registerSpriteSet((ParticleType)ModParticleTypes.FALLING_ACID.get(), ParticleProviders.AcidFallProvider::new);
        event.registerSpriteSet((ParticleType)ModParticleTypes.LANDING_ACID.get(), ParticleProviders.AcidLandProvider::new);
    }

    @SubscribeEvent
    public static void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
    }

    private static void registerItemModelProperties() {
        ItemPropertyFunction shieldPropertyFunc = (stack, level, livingEntity, seed) -> livingEntity != null && livingEntity.m_6117_() && livingEntity.m_21211_() == stack ? 1.0f : 0.0f;
        ItemProperties.register((Item)((Item)ModItems.THORN_SHIELD.get()), (ResourceLocation)new ResourceLocation("blocking"), (ItemPropertyFunction)shieldPropertyFunc);
        ItemProperties.register((Item)((Item)ModItems.CAUSTIC_GUNBLADE.get()), (ResourceLocation)new ResourceLocation("melee"), (stack, level, livingEntity, seed) -> GunbladeItem.GunbladeMode.from(stack) == GunbladeItem.GunbladeMode.MELEE ? 1.0f : 0.0f);
    }

    @SubscribeEvent
    public static void registerLayers(EntityRenderersEvent.AddLayers event) {
    }

    @SubscribeEvent
    public static void onBlockModelRegistry(ModelEvent.RegisterAdditional event) {
    }

    @SubscribeEvent
    public static void onItemColorRegistry(RegisterColorHandlersEvent.Item event) {
        event.register((stack, tintIndex) -> ((EssenceItem)ModItems.ESSENCE.get()).getColor(stack, tintIndex), new ItemLike[]{(ItemLike)ModItems.ESSENCE.get()});
        event.register((stack, index) -> index == 1 ? IClientFluidTypeExtensions.of((Fluid)((BucketItem)stack.m_41720_()).getFluid()).getTintColor() : -1, new ItemLike[]{(ItemLike)ModItems.ACID_BUCKET.get()});
        event.register(BiometricMembraneBlock::getTintColor, new ItemLike[]{(ItemLike)ModItems.BIOMETRIC_MEMBRANE.get()});
    }

    @SubscribeEvent
    public static void onBlockColorRegistry(RegisterColorHandlersEvent.Block event) {
        event.register(VialHolderBlock::getTintColor, new Block[]{(Block)ModBlocks.VIAL_HOLDER.get()});
        event.register(BiometricMembraneBlock::getTintColor, new Block[]{(Block)ModBlocks.BIOMETRIC_MEMBRANE.get()});
    }

    @SubscribeEvent
    public static void registerGameOverlays(RegisterGuiOverlaysEvent event) {
        event.registerAbove(VanillaGuiOverlay.CROSSHAIR.id(), "injector", IngameOverlays.INJECTOR_OVERLAY);
        event.registerAbove(VanillaGuiOverlay.CROSSHAIR.id(), "charge_bar", IngameOverlays.CHARGE_BAR_OVERLAY);
        event.registerAbove(VanillaGuiOverlay.CROSSHAIR.id(), "gun", IngameOverlays.GUN_OVERLAY);
    }

    @SubscribeEvent
    static void registerTooltipComponents(RegisterClientTooltipComponentFactoriesEvent event) {
        event.register(HrTooltipComponent.class, HrTooltipClientComponent::new);
        event.register(EmptyLineTooltipComponent.class, EmptyLineClientComponent::new);
        event.register(StorageSacTooltipComponent.class, StorageSacTooltipClientComponent::new);
    }
}

