/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.init.client;

import com.github.elenterius.biomancy.crafting.recipe.BioForgeRecipe;
import com.github.elenterius.biomancy.init.ModBioForgeTabs;
import com.github.elenterius.biomancy.init.ModRecipeBookTypes;
import com.github.elenterius.biomancy.init.ModRecipes;
import com.github.elenterius.biomancy.menu.BioForgeTab;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.RecipeBookCategories;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterRecipeBookCategoriesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="biomancy", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public final class ModRecipeBookCategories {
    private ModRecipeBookCategories() {
    }

    public static RecipeBookCategories getRecipeBookCategories(BioForgeTab category) {
        return BioForgeCategories.TAB_TO_CATEGORY.get(category.enumId());
    }

    @SubscribeEvent
    public static void registerRecipeBooks(RegisterRecipeBookCategoriesEvent event) {
        BioForgeCategories.register(event);
        event.registerRecipeCategoryFinder((RecipeType)ModRecipes.BIO_BREWING_RECIPE_TYPE.get(), rc -> RecipeBookCategories.UNKNOWN);
        event.registerRecipeCategoryFinder((RecipeType)ModRecipes.DECOMPOSING_RECIPE_TYPE.get(), rc -> RecipeBookCategories.UNKNOWN);
        event.registerRecipeCategoryFinder((RecipeType)ModRecipes.DIGESTING_RECIPE_TYPE.get(), rc -> RecipeBookCategories.UNKNOWN);
    }

    private static final class BioForgeCategories {
        private static final Map<String, RecipeBookCategories> TAB_TO_CATEGORY = new HashMap<String, RecipeBookCategories>();
        public static final RecipeBookCategories SEARCH_CATEGORY = BioForgeCategories.createAndRegisterSearchCategory();
        public static final Function<Recipe<?>, RecipeBookCategories> RECIPE_CATEGORY_FINDER = recipe -> {
            if (recipe instanceof BioForgeRecipe) {
                BioForgeRecipe bioForgeRecipe = (BioForgeRecipe)recipe;
                return TAB_TO_CATEGORY.get(bioForgeRecipe.getTab().enumId());
            }
            return null;
        };

        private BioForgeCategories() {
        }

        private static RecipeBookCategories createAndRegisterSearchCategory() {
            BioForgeTab tab = (BioForgeTab)ModBioForgeTabs.SEARCH.get();
            String name = tab.enumId();
            RecipeBookCategories category = RecipeBookCategories.create((String)name, (ItemStack[])new ItemStack[]{tab.getIcon()});
            TAB_TO_CATEGORY.put(name, category);
            return category;
        }

        private static void registerCategories() {
            for (Map.Entry entry : ModBioForgeTabs.REGISTRY.get().getEntries()) {
                BioForgeTab tab = (BioForgeTab)entry.getValue();
                if (tab == ModBioForgeTabs.SEARCH.get()) continue;
                String name = tab.enumId();
                RecipeBookCategories categories = RecipeBookCategories.create((String)name, (ItemStack[])new ItemStack[]{tab.getIcon()});
                TAB_TO_CATEGORY.put(name, categories);
            }
        }

        private static void register(RegisterRecipeBookCategoriesEvent event) {
            BioForgeCategories.registerCategories();
            List<RecipeBookCategories> categories = TAB_TO_CATEGORY.values().stream().toList();
            event.registerBookCategories(ModRecipeBookTypes.BIO_FORGE, categories);
            event.registerAggregateCategory(SEARCH_CATEGORY, categories);
            event.registerRecipeCategoryFinder((RecipeType)ModRecipes.BIO_FORGING_RECIPE_TYPE.get(), RECIPE_CATEGORY_FINDER);
        }
    }
}

