/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.integration.jei;

import com.github.elenterius.biomancy.BiomancyMod;
import com.github.elenterius.biomancy.client.gui.BioForgeScreen;
import com.github.elenterius.biomancy.client.gui.BioLabScreen;
import com.github.elenterius.biomancy.client.gui.DecomposerScreen;
import com.github.elenterius.biomancy.client.gui.DigesterScreen;
import com.github.elenterius.biomancy.init.ModItems;
import com.github.elenterius.biomancy.init.ModMenuTypes;
import com.github.elenterius.biomancy.init.ModRecipes;
import com.github.elenterius.biomancy.integration.jei.BioForgeRecipeCategory;
import com.github.elenterius.biomancy.integration.jei.BioLabRecipeCategory;
import com.github.elenterius.biomancy.integration.jei.BiometricMembraneRecipeMaker;
import com.github.elenterius.biomancy.integration.jei.CradleCleansingRecipeMaker;
import com.github.elenterius.biomancy.integration.jei.DecomposerRecipeCategory;
import com.github.elenterius.biomancy.integration.jei.DigesterRecipeCategory;
import com.github.elenterius.biomancy.menu.BioLabMenu;
import com.github.elenterius.biomancy.menu.DecomposerMenu;
import com.github.elenterius.biomancy.menu.DigesterMenu;
import com.github.elenterius.biomancy.menu.slot.ISlotZone;
import java.util.Objects;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

@JeiPlugin
public class BiomancyJeiPlugin
implements IModPlugin {
    private static final ResourceLocation ID = BiomancyMod.createRL("plugin");

    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new DecomposerRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new BioLabRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new DigesterRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new BioForgeRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        ClientLevel level = Objects.requireNonNull(Minecraft.m_91087_().f_91073_);
        registration.addRecipes(DecomposerRecipeCategory.RECIPE_TYPE, level.m_7465_().m_44013_((net.minecraft.world.item.crafting.RecipeType)ModRecipes.DECOMPOSING_RECIPE_TYPE.get()));
        registration.addRecipes(BioLabRecipeCategory.RECIPE_TYPE, level.m_7465_().m_44013_((net.minecraft.world.item.crafting.RecipeType)ModRecipes.BIO_BREWING_RECIPE_TYPE.get()));
        registration.addRecipes(DigesterRecipeCategory.RECIPE_TYPE, level.m_7465_().m_44013_((net.minecraft.world.item.crafting.RecipeType)ModRecipes.DIGESTING_RECIPE_TYPE.get()));
        registration.addRecipes(BioForgeRecipeCategory.RECIPE_TYPE, level.m_7465_().m_44013_((net.minecraft.world.item.crafting.RecipeType)ModRecipes.BIO_FORGING_RECIPE_TYPE.get()));
        registration.addRecipes(RecipeTypes.CRAFTING, BiometricMembraneRecipeMaker.createRecipes());
        registration.addRecipes(RecipeTypes.CRAFTING, CradleCleansingRecipeMaker.createRecipes());
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModItems.BIO_FORGE.get()), new RecipeType[]{BioForgeRecipeCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModItems.BIO_LAB.get()), new RecipeType[]{BioLabRecipeCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModItems.DIGESTER.get()), new RecipeType[]{DigesterRecipeCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModItems.DECOMPOSER.get()), new RecipeType[]{DecomposerRecipeCategory.RECIPE_TYPE});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(DecomposerScreen.class, 161, 4, 10, 10, new RecipeType[]{DecomposerRecipeCategory.RECIPE_TYPE});
        registration.addRecipeClickArea(BioLabScreen.class, 161, 4, 10, 10, new RecipeType[]{BioLabRecipeCategory.RECIPE_TYPE});
        registration.addRecipeClickArea(DigesterScreen.class, 161, 4, 10, 10, new RecipeType[]{DigesterRecipeCategory.RECIPE_TYPE});
        registration.addRecipeClickArea(BioForgeScreen.class, 277, 4, 10, 10, new RecipeType[]{BioForgeRecipeCategory.RECIPE_TYPE});
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        this.registerInputSlots(registration, (MenuType)ModMenuTypes.DECOMPOSER.get(), DecomposerMenu.class, DecomposerRecipeCategory.RECIPE_TYPE, DecomposerMenu.SlotZone.INPUT_ZONE);
        this.registerInputSlots(registration, (MenuType)ModMenuTypes.BIO_LAB.get(), BioLabMenu.class, BioLabRecipeCategory.RECIPE_TYPE, BioLabMenu.SlotZone.INPUT_ZONE);
        this.registerInputSlots(registration, (MenuType)ModMenuTypes.DIGESTER.get(), DigesterMenu.class, DigesterRecipeCategory.RECIPE_TYPE, DigesterMenu.SlotZone.INPUT_ZONE);
    }

    private <C extends AbstractContainerMenu, R> void registerInputSlots(IRecipeTransferRegistration registration, @Nullable MenuType<C> menuType, Class<? extends C> containerClass, RecipeType<R> recipeType, ISlotZone slotZone) {
        registration.addRecipeTransferHandler(containerClass, menuType, recipeType, slotZone.getFirstIndex(), slotZone.getSlotCount(), 0, 36);
    }
}

