/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.integration.jei;

import com.github.elenterius.biomancy.BiomancyMod;
import com.github.elenterius.biomancy.block.membrane.BiometricMembraneBlock;
import com.github.elenterius.biomancy.init.ModItems;
import com.github.elenterius.biomancy.item.EssenceItem;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;

public final class BiometricMembraneRecipeMaker {
    private BiometricMembraneRecipeMaker() {
    }

    public static List<CraftingRecipe> createRecipes() {
        EntityType entityType = EntityType.f_20510_;
        Stream<CraftingRecipe[]> recipePairs = Stream.of(BiometricMembraneRecipeMaker.createRecipePair((EntityType<Pig>)entityType, false, false), BiometricMembraneRecipeMaker.createRecipePair((EntityType<Pig>)entityType, true, false), BiometricMembraneRecipeMaker.createRecipePair((EntityType<Pig>)entityType, false, true), BiometricMembraneRecipeMaker.createRecipePair((EntityType<Pig>)entityType, true, true));
        return recipePairs.flatMap(Stream::of).toList();
    }

    private static CraftingRecipe[] createRecipePair(EntityType<Pig> entityType, boolean isInverted, boolean isUnique) {
        ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>();
        ingredients.add(Ingredient.m_43927_((ItemStack[])new ItemStack[]{EssenceItem.fromEntityType(entityType, 1)}));
        ingredients.add(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.BIOMETRIC_MEMBRANE.get()}));
        if (isInverted) {
            ingredients.add(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41978_}));
        }
        NonNullList inputs = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])((Ingredient[])ingredients.toArray(Ingredient[]::new)));
        UUID entityUUID = isUnique ? UUID.fromString("420faf42-bf42-4b20-af42-c42420e42d42") : null;
        ItemStack membraneStack = BiometricMembraneBlock.createItem(entityType, entityUUID, EssenceItem.getEssenceColors(entityType), isInverted);
        String name = ModItems.BIOMETRIC_MEMBRANE.getId().m_214298_();
        String inverted = isInverted ? "inverted." : "";
        String unique = isUnique ? "unique." : "";
        ResourceLocation createRecipeId = BiomancyMod.createRL(name + "." + inverted + unique + entityType.m_20675_());
        ResourceLocation resetRecipeId = BiomancyMod.createRL(name + ".reset." + inverted + unique + entityType.m_20675_());
        return new CraftingRecipe[]{new ShapelessRecipe(createRecipeId, name, CraftingBookCategory.MISC, membraneStack, inputs), new ShapelessRecipe(resetRecipeId, name, CraftingBookCategory.MISC, new ItemStack((ItemLike)ModItems.BIOMETRIC_MEMBRANE.get()), NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{Ingredient.m_43927_((ItemStack[])new ItemStack[]{membraneStack})}))};
    }
}

