/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.integration.pehkui;

import com.github.elenterius.biomancy.BiomancyMod;
import com.github.elenterius.biomancy.integration.pehkui.PehkuiHelper;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import virtuoel.pehkui.api.ScaleData;
import virtuoel.pehkui.api.ScaleModifier;
import virtuoel.pehkui.api.ScaleRegistries;
import virtuoel.pehkui.api.ScaleType;
import virtuoel.pehkui.api.ScaleTypes;

public final class PehkuiCompat {
    private static final ScaleModifier SCALE_MODIFIER = PehkuiCompat.registerScaleModifier("scale", () -> new ScaleModifier(){

        public float modifyScale(ScaleData scaleData, float modifiedScale, float delta) {
            return SCALE_TYPE.getScaleData(scaleData.getEntity()).getScale(delta) * modifiedScale;
        }
    });
    private static final ScaleType SCALE_TYPE = PehkuiCompat.registerScaleType("size", builder -> builder.affectsDimensions().addDependentModifier(SCALE_MODIFIER));

    private PehkuiCompat() {
    }

    public static void init(Consumer<PehkuiHelper> helperSetter) {
        ScaleTypes.BASE.getDefaultBaseValueModifiers().add(SCALE_MODIFIER);
        helperSetter.accept(new PehkuiHelperImpl());
    }

    private static ScaleModifier registerScaleModifier(String name, Supplier<ScaleModifier> factory) {
        return (ScaleModifier)ScaleRegistries.register((Map)ScaleRegistries.SCALE_MODIFIERS, (ResourceLocation)BiomancyMod.createRL(name), (Object)factory.get());
    }

    private static ScaleType registerScaleType(String name, UnaryOperator<ScaleType.Builder> builder) {
        return (ScaleType)ScaleRegistries.register((Map)ScaleRegistries.SCALE_TYPES, (ResourceLocation)BiomancyMod.createRL(name), (Object)((ScaleType.Builder)builder.apply(ScaleType.Builder.create())).build());
    }

    static final class PehkuiHelperImpl
    implements PehkuiHelper {
        PehkuiHelperImpl() {
        }

        @Override
        public void setScale(LivingEntity livingEntity, float scale) {
            SCALE_TYPE.getScaleData((Entity)livingEntity).setTargetScale(scale);
        }

        @Override
        public void resetSize(LivingEntity livingEntity) {
            this.setScale(livingEntity, 1.0f);
        }

        @Override
        public void resize(LivingEntity livingEntity, float multiplier) {
            ScaleData scaleData = SCALE_TYPE.getScaleData((Entity)livingEntity);
            scaleData.setTargetScale(scaleData.getScale() * multiplier);
        }

        @Override
        public float getScale(LivingEntity livingEntity) {
            ScaleData scaleData = SCALE_TYPE.getScaleData((Entity)livingEntity);
            return scaleData.getScale();
        }
    }
}

