/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.inventory.itemhandler;

import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public abstract class ItemHandlerDelegator<T extends IItemHandler & IItemHandlerModifiable>
implements IItemHandler,
IItemHandlerModifiable,
INBTSerializable<CompoundTag> {
    protected final T itemStackHandler;

    protected ItemHandlerDelegator(T itemStackHandlerIn) {
        this.itemStackHandler = itemStackHandlerIn;
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        ((IItemHandlerModifiable)this.itemStackHandler).setStackInSlot(slot, stack);
    }

    public int getSlots() {
        return this.itemStackHandler.getSlots();
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        return this.itemStackHandler.getStackInSlot(slot);
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        return this.itemStackHandler.insertItem(slot, stack, simulate);
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return this.itemStackHandler.extractItem(slot, amount, simulate);
    }

    public int getSlotLimit(int slot) {
        return this.itemStackHandler.getSlotLimit(slot);
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return this.itemStackHandler.isItemValid(slot, stack);
    }

    public CompoundTag serializeNBT() {
        return (CompoundTag)((INBTSerializable)this.itemStackHandler).serializeNBT();
    }

    public void deserializeNBT(CompoundTag nbt) {
        ((INBTSerializable)this.itemStackHandler).deserializeNBT((Tag)nbt);
    }

    public static class FilterInput<T extends IItemHandler & IItemHandlerModifiable>
    extends ItemHandlerDelegator<T> {
        private final Predicate<ItemStack> validItems;

        public FilterInput(T itemStackHandlerIn, Predicate<ItemStack> validItems) {
            super(itemStackHandlerIn);
            this.validItems = validItems;
        }

        @Override
        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return this.validItems.test(stack) && this.itemStackHandler.isItemValid(slot, stack);
        }

        @Override
        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (!this.validItems.test(stack)) {
                return stack;
            }
            return this.itemStackHandler.insertItem(slot, stack, simulate);
        }
    }

    public static class DenyInput<T extends IItemHandler & IItemHandlerModifiable>
    extends ItemHandlerDelegator<T> {
        public DenyInput(T itemStackHandlerIn) {
            super(itemStackHandlerIn);
        }

        @Override
        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return false;
        }

        @Override
        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            return stack;
        }
    }
}

