/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.inventory.itemhandler;

import com.github.elenterius.biomancy.inventory.itemhandler.SingleItemStackHandler;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;

public class LargeSingleItemStackHandler
extends SingleItemStackHandler {
    public static final String ITEM_AMOUNT_TAG = "ItemAmount";
    private final short maxItemAmount;
    private short itemAmount;

    public LargeSingleItemStackHandler() {
        this(Short.MAX_VALUE);
    }

    public LargeSingleItemStackHandler(short maxItemAmount) {
        this.maxItemAmount = maxItemAmount;
    }

    @Override
    public int getSlotLimit(int slot) {
        return this.maxItemAmount;
    }

    @Override
    public int getMaxAmount() {
        return this.maxItemAmount;
    }

    @Override
    public int getAmount() {
        return this.itemAmount;
    }

    @Override
    public void setAmount(short amount) {
        if (!this.cachedStack.m_41619_()) {
            int value = Mth.m_14045_((int)amount, (int)0, (int)this.getMaxAmount());
            this.itemAmount = (short)value;
            this.cachedStack.m_41764_(value);
            this.onContentsChanged();
        }
    }

    @Override
    public void setStack(ItemStack stack) {
        this.cachedStack = stack;
        this.itemAmount = (short)this.cachedStack.m_41613_();
        this.onContentsChanged();
    }

    @Override
    public ItemStack insertItem(int slot, ItemStack stackIn, boolean simulate) {
        ItemStack remainder = this.internalInsertItem(slot, stackIn, simulate);
        if (!simulate) {
            this.itemAmount = (short)this.cachedStack.m_41613_();
            this.onContentsChanged();
        }
        return remainder;
    }

    @Override
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemStack remainder = this.internalExtractItem(slot, amount, simulate);
        if (!simulate) {
            this.itemAmount = (short)this.cachedStack.m_41613_();
            this.onContentsChanged();
        }
        return remainder;
    }

    @Override
    public void serializeItemAmount(CompoundTag tag) {
        tag.m_128376_(ITEM_AMOUNT_TAG, this.itemAmount);
    }

    @Override
    public int deserializeItemAmount(CompoundTag tag) {
        this.itemAmount = tag.m_128448_(ITEM_AMOUNT_TAG);
        return this.itemAmount;
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        if (!this.cachedStack.m_41619_()) {
            this.serializeItemAmount(tag);
            if (this.itemAmount > 127) {
                this.cachedStack.m_41764_(127);
                tag.m_128365_("Item", (Tag)this.cachedStack.m_41739_(new CompoundTag()));
                this.cachedStack.m_41764_((int)this.itemAmount);
            } else {
                tag.m_128365_("Item", (Tag)this.cachedStack.m_41739_(new CompoundTag()));
            }
        }
        return tag;
    }

    @Override
    public void deserializeNBT(CompoundTag tag) {
        ItemStack itemStack = this.cachedStack = tag.m_128441_("Item") ? ItemStack.m_41712_((CompoundTag)tag.m_128469_("Item")) : ItemStack.f_41583_;
        if (!this.cachedStack.m_41619_()) {
            this.cachedStack.m_41764_(this.deserializeItemAmount(tag));
        }
    }
}

