/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.inventory.itemhandler;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class SingleItemStackHandler
implements IItemHandler,
IItemHandlerModifiable,
INBTSerializable<CompoundTag> {
    public static final String ITEM_TAG = "Item";
    protected ItemStack cachedStack = ItemStack.f_41583_;

    protected void validateSlotIndex(int slot) {
        if (slot != 0) {
            throw new IllegalArgumentException("Slot " + slot + " not valid - must be 0");
        }
    }

    public int getSlots() {
        return 1;
    }

    public int getSlotLimit(int slot) {
        return this.cachedStack.m_41741_();
    }

    public boolean isItemValid(ItemStack stack) {
        return true;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return slot == 0 && this.isItemValid(stack);
    }

    public boolean isEmpty() {
        return this.cachedStack.m_41619_();
    }

    public boolean isFull() {
        return !this.isEmpty() && this.getAmount() >= this.getMaxAmount();
    }

    public int getAmount() {
        return this.cachedStack.m_41613_();
    }

    public void setAmount(short amount) {
        if (!this.cachedStack.m_41619_()) {
            this.cachedStack.m_41764_(Mth.m_14045_((int)amount, (int)0, (int)this.getMaxAmount()));
            this.onContentsChanged();
        }
    }

    public int getMaxAmount() {
        return this.getSlotLimit(0);
    }

    public Item getItem() {
        return this.cachedStack.m_41720_();
    }

    public ItemStack getStack() {
        return this.cachedStack;
    }

    public void setStack(ItemStack stack) {
        this.cachedStack = stack;
        this.onContentsChanged();
    }

    public ItemStack getStackInSlot(int slot) {
        this.validateSlotIndex(slot);
        return this.cachedStack;
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        this.validateSlotIndex(slot);
        this.setStack(stack);
    }

    public ItemStack insertItem(ItemStack stack, boolean simulate) {
        return this.insertItem(0, stack, simulate);
    }

    public ItemStack insertItem(int slot, ItemStack stackIn, boolean simulate) {
        ItemStack remainder = this.internalInsertItem(slot, stackIn, simulate);
        if (!simulate) {
            this.onContentsChanged();
        }
        return remainder;
    }

    protected ItemStack internalInsertItem(int slot, ItemStack stackIn, boolean simulate) {
        int overflow;
        this.validateSlotIndex(slot);
        if (stackIn.m_41619_()) {
            return ItemStack.f_41583_;
        }
        if (!this.isItemValid(slot, stackIn)) {
            return stackIn;
        }
        if (!this.cachedStack.m_41619_() && !ItemHandlerHelper.canItemStacksStack((ItemStack)stackIn, (ItemStack)this.cachedStack)) {
            return stackIn;
        }
        if (this.getAmount() >= this.getMaxAmount()) {
            return stackIn;
        }
        int insertGoal = stackIn.m_41613_();
        int newAmount = this.getAmount() + insertGoal;
        int n = overflow = newAmount > this.getMaxAmount() ? newAmount - this.getMaxAmount() : 0;
        if (!simulate) {
            int insertAmount;
            int n2 = insertAmount = overflow > 0 ? insertGoal - overflow : insertGoal;
            if (this.cachedStack.m_41619_()) {
                this.cachedStack = ItemHandlerHelper.copyStackWithSize((ItemStack)stackIn, (int)insertAmount);
            } else {
                this.cachedStack.m_41769_(insertAmount);
            }
        }
        return overflow > 0 ? ItemHandlerHelper.copyStackWithSize((ItemStack)stackIn, (int)overflow) : ItemStack.f_41583_;
    }

    public ItemStack extractItem(int amount, boolean simulate) {
        return this.extractItem(0, amount, simulate);
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemStack remainder = this.internalExtractItem(slot, amount, simulate);
        if (!simulate) {
            this.onContentsChanged();
        }
        return remainder;
    }

    protected ItemStack internalExtractItem(int slot, int amount, boolean simulate) {
        this.validateSlotIndex(slot);
        if (amount == 0) {
            return ItemStack.f_41583_;
        }
        if (this.cachedStack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        int extractGoal = Math.min(amount, this.getMaxAmount());
        if (this.getAmount() <= extractGoal) {
            if (!simulate) {
                ItemStack stack = this.cachedStack;
                this.cachedStack = ItemStack.f_41583_;
                return stack;
            }
            return this.cachedStack.m_41777_();
        }
        if (!simulate) {
            this.cachedStack.m_41769_(-extractGoal);
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)this.cachedStack, (int)extractGoal);
    }

    public void serializeItemAmount(CompoundTag tag) {
    }

    public int deserializeItemAmount(CompoundTag tag) {
        return -1;
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        this.serializeItemAmount(nbt);
        if (!this.cachedStack.m_41619_()) {
            int count = this.cachedStack.m_41613_();
            if (count > 64) {
                this.cachedStack.m_41764_(64);
            }
            nbt.m_128365_(ITEM_TAG, (Tag)this.cachedStack.m_41739_(new CompoundTag()));
            if (count != this.cachedStack.m_41613_()) {
                this.cachedStack.m_41764_(count);
            }
        }
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.cachedStack = nbt.m_128441_(ITEM_TAG) ? ItemStack.m_41712_((CompoundTag)nbt.m_128469_(ITEM_TAG)) : ItemStack.f_41583_;
        int itemAmount = this.deserializeItemAmount(nbt);
        if (itemAmount > this.cachedStack.m_41613_()) {
            this.cachedStack.m_41764_(itemAmount);
        }
    }

    protected void onContentsChanged() {
    }
}

