/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.item.weapon.gun;

import com.github.elenterius.biomancy.BiomancyMod;
import com.github.elenterius.biomancy.api.livingtool.SimpleLivingTool;
import com.github.elenterius.biomancy.client.render.item.caustic_gunblade.CausticGunbladeRenderer;
import com.github.elenterius.biomancy.client.util.ClientTextUtil;
import com.github.elenterius.biomancy.init.ModDamageSources;
import com.github.elenterius.biomancy.init.ModMobEffects;
import com.github.elenterius.biomancy.init.ModParticleTypes;
import com.github.elenterius.biomancy.init.ModProjectiles;
import com.github.elenterius.biomancy.init.ModSoundEvents;
import com.github.elenterius.biomancy.item.CriticalHitListener;
import com.github.elenterius.biomancy.item.ItemAttackDamageSourceProvider;
import com.github.elenterius.biomancy.item.ItemTooltipStyleProvider;
import com.github.elenterius.biomancy.item.weapon.BladeProperties;
import com.github.elenterius.biomancy.item.weapon.gun.Gun;
import com.github.elenterius.biomancy.item.weapon.gun.GunProperties;
import com.github.elenterius.biomancy.item.weapon.gun.GunbladeItem;
import com.github.elenterius.biomancy.styles.TextComponentUtil;
import com.github.elenterius.biomancy.styles.TextStyles;
import com.github.elenterius.biomancy.util.ComponentUtil;
import com.github.elenterius.biomancy.util.animation.TriggerableAnimation;
import com.github.elenterius.biomancy.util.function.FloatOperator;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.ToolAction;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class CausticGunbladeItem
extends GunbladeItem
implements SimpleLivingTool,
CriticalHitListener,
ItemAttackDamageSourceProvider,
ItemTooltipStyleProvider,
GeoItem {
    protected final Multimap<Attribute, AttributeModifier> disabledBladeModifiers;
    protected final Multimap<Attribute, AttributeModifier> disabledGunModifiers;
    private final int maxNutrients;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    String LAST_USE_TIMESTAMP_KEY = "last_use_timestamp";

    public CausticGunbladeItem(int maxNutrients, Item.Properties itemProperties) {
        super(itemProperties, BladeProperties.builder().attackDamage(6.0f).attackSpeed(1.2f).build(), GunProperties.builder().fireRate(0.5f).maxAmmo(10).reloadDuration(200).autoReload(true).build(), ModProjectiles.ACID_BLOB);
        this.maxNutrients = maxNutrients;
        this.disabledBladeModifiers = ImmutableMultimap.builder().putAll((Object)Attributes.f_22283_, (Iterable)this.defaultBladeModifiers.get((Object)Attributes.f_22283_)).build();
        this.disabledGunModifiers = ImmutableMultimap.builder().putAll((Object)Attributes.f_22283_, (Iterable)this.defaultGunModifiers.get((Object)Attributes.f_22283_)).build();
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    @Override
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        if (slot == EquipmentSlot.MAINHAND) {
            boolean isMeleeMode = GunbladeItem.GunbladeMode.from(stack).isBlade();
            if (this.hasNutrients(stack)) {
                return isMeleeMode ? this.defaultBladeModifiers : this.defaultGunModifiers;
            }
            return isMeleeMode ? this.disabledBladeModifiers : this.disabledGunModifiers;
        }
        return ImmutableMultimap.of();
    }

    private static void playSwipeFX(LivingEntity attacker) {
        attacker.m_9236_().m_6263_(null, attacker.m_20185_(), attacker.m_20186_(), attacker.m_20189_(), (SoundEvent)ModSoundEvents.CLAWS_ATTACK_STRONG.get(), attacker.m_5720_(), 1.0f, 1.0f + attacker.m_217043_().m_188501_() * 0.5f);
        Level level = attacker.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            double xOffset = -Mth.m_14031_((float)(attacker.m_146908_() * ((float)Math.PI / 180)));
            double zOffset = Mth.m_14089_((float)(attacker.m_146908_() * ((float)Math.PI / 180)));
            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.CORROSIVE_SWIPE_ATTACK.get()), attacker.m_20185_() + xOffset, attacker.m_20227_((double)0.52f), attacker.m_20189_() + zOffset, 0, xOffset, 0.0, zOffset, 0.0);
        }
    }

    public Predicate<ItemStack> m_6437_() {
        return itemStack -> false;
    }

    public int m_6615_() {
        return 16;
    }

    protected long getLastUseTimestamp(ItemStack stack) {
        return stack.m_41784_().m_128454_(this.LAST_USE_TIMESTAMP_KEY);
    }

    protected void setLastUseTimestamp(ItemStack stack, long timestamp) {
        stack.m_41784_().m_128356_(this.LAST_USE_TIMESTAMP_KEY, timestamp);
    }

    @Override
    public void shoot(ServerLevel level, LivingEntity shooter, InteractionHand usedHand, ItemStack projectileWeapon) {
        this.broadcastAnimation(level, (Entity)shooter, projectileWeapon, Animations.SHOOT);
        this.configuredProjectile.shoot((Level)level, shooter, FloatOperator.IDENTITY, baseDamage -> this.modifyProjectileDamage(baseDamage, projectileWeapon), baseKnockBack -> this.modifyProjectileKnockBack(baseKnockBack, projectileWeapon), baseInaccuracy -> this.modifyProjectileInaccuracy(baseInaccuracy, projectileWeapon));
        this.consumeAmmo(shooter, projectileWeapon, 1);
        this.consumeNutrients(projectileWeapon, 1);
        this.setLastUseTimestamp(projectileWeapon, level.m_46467_());
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!this.hasNutrients(stack)) {
            if (level.m_5776_()) {
                player.m_5661_((Component)TextComponentUtil.getFailureMsgText("not_enough_nutrients"), true);
                this.playSound(player, (SoundEvent)ModSoundEvents.FLESHKIN_NO.get());
            }
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        return super.m_7203_(level, player, hand);
    }

    @Override
    public void m_5929_(Level level, LivingEntity shooter, ItemStack stack, int remainingUseDuration) {
        if (level.f_46443_) {
            return;
        }
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (this.getGunState(stack) != Gun.GunState.SHOOTING) {
            return;
        }
        if (!this.hasNutrients(stack)) {
            shooter.m_21253_();
            this.stopShooting(stack, serverLevel, shooter);
        } else {
            super.m_5929_(level, shooter, stack, remainingUseDuration);
        }
    }

    @Override
    public InteractionResultHolder<ItemStack> useInMeleeMode(Level level, Player player, InteractionHand usedHand, ItemStack stack) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.getAmmo(stack) > 1 && !Abilities.ACID_COAT.isActive(stack)) {
                this.consumeAmmo((LivingEntity)player, stack, 1);
                Abilities.ACID_COAT.setActive(serverLevel, stack, (LivingEntity)player);
                this.broadcastAnimation(serverLevel, (Entity)player, stack, Animations.COAT_BLADES);
                this.setLastUseTimestamp(stack, serverLevel.m_46467_());
            }
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    @Override
    public void m_6883_(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (level.f_46443_) {
            return;
        }
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity shooter = (LivingEntity)entity;
        if (isSelected) {
            Abilities.ACID_COAT.tick((Level)serverLevel, stack, shooter);
            if (this.getGunState(stack) == Gun.GunState.NONE && !Abilities.ACID_COAT.isActive(stack) && this.canReload(stack, shooter)) {
                this.startReload(stack, serverLevel, shooter);
                return;
            }
        }
        super.m_6883_(stack, level, entity, slotId, isSelected);
    }

    @Override
    public boolean canReload(ItemStack stack, LivingEntity shooter) {
        long elapsedTime = shooter.m_9236_().m_46467_() - this.getLastUseTimestamp(stack);
        return elapsedTime > 100L && this.getAmmo(stack) < this.getMaxAmmo(stack) && this.getNutrients(stack) >= this.getAmmoReloadCost();
    }

    @Override
    public int getAmmoReloadCost() {
        return 5;
    }

    @Override
    public ItemStack findAmmoInInv(ItemStack stack, LivingEntity shooter) {
        return new ItemStack((ItemLike)Items.f_42412_, 64);
    }

    @Override
    @Nullable
    public DamageSource getDamageSource(ItemStack stack, Entity target, LivingEntity attacker) {
        if (GunbladeItem.GunbladeMode.from(stack) != GunbladeItem.GunbladeMode.MELEE) {
            return null;
        }
        if (!Abilities.ACID_COAT.isActive(stack)) {
            return null;
        }
        return ModDamageSources.acid(attacker.m_9236_(), (Entity)attacker);
    }

    @Override
    public void onCriticalHitEntity(ItemStack stack, LivingEntity attacker, LivingEntity target) {
        if (attacker.m_9236_().f_46443_) {
            return;
        }
        if (GunbladeItem.GunbladeMode.from(stack) != GunbladeItem.GunbladeMode.MELEE) {
            return;
        }
        if (Abilities.ACID_COAT.isActive(stack)) {
            target.m_7292_(new MobEffectInstance((MobEffect)ModMobEffects.ARMOR_SHRED.get(), 80, 1));
        }
    }

    @Override
    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (attacker.m_9236_().f_46443_) {
            return true;
        }
        this.setLastUseTimestamp(stack, attacker.m_9236_().m_46467_());
        this.consumeNutrients(stack, 2);
        if (GunbladeItem.GunbladeMode.from(stack) != GunbladeItem.GunbladeMode.MELEE) {
            return true;
        }
        if (Abilities.ACID_COAT.isActive(stack)) {
            Player player;
            boolean isFullAttackStrength;
            boolean bl = isFullAttackStrength = !(attacker instanceof Player) || (player = (Player)attacker).m_36403_(0.5f) >= 0.9f;
            if (isFullAttackStrength) {
                CausticGunbladeItem.playSwipeFX(attacker);
                target.m_7292_(new MobEffectInstance((MobEffect)ModMobEffects.CORROSIVE.get(), 40, 0));
                target.m_7292_(new MobEffectInstance((MobEffect)ModMobEffects.ARMOR_SHRED.get(), 80, 0));
            }
        }
        return true;
    }

    @Override
    public void onChangeGunbladeMode(ServerLevel level, LivingEntity shooter, ItemStack stack) {
        Abilities.ACID_COAT.cancel(level, stack, shooter);
        this.setLastUseTimestamp(stack, level.m_46467_());
        SoundEvent soundEvent = GunbladeItem.GunbladeMode.from(stack) == GunbladeItem.GunbladeMode.MELEE ? (SoundEvent)ModSoundEvents.FLESHKIN_BECOME_DORMANT.get() : (SoundEvent)ModSoundEvents.FLESHKIN_BECOME_AWAKENED.get();
        this.playSFX((Level)level, shooter, soundEvent);
    }

    @Override
    public void onReloadTick(ItemStack stack, ServerLevel level, LivingEntity shooter, long elapsedTime) {
    }

    @Override
    public void onReloadStarted(ItemStack stack, ServerLevel level, LivingEntity shooter) {
        this.playSFX((Level)level, shooter, SoundEvents.f_11912_);
    }

    @Override
    public void onReloadCanceled(ItemStack stack, ServerLevel level, LivingEntity shooter) {
        this.playSFX((Level)level, shooter, SoundEvents.f_12528_);
    }

    @Override
    public void onReloadStopped(ItemStack stack, ServerLevel level, LivingEntity shooter) {
        this.playSFX((Level)level, shooter, SoundEvents.f_12528_);
    }

    @Override
    public void onReloadFinished(ItemStack stack, ServerLevel level, LivingEntity shooter) {
        this.consumeNutrients(stack, this.getAmmoReloadCost());
        this.playSFX((Level)level, shooter, SoundEvents.f_12321_);
    }

    public Component getHighlightTip(ItemStack stack, Component displayName) {
        return !Abilities.ACID_COAT.isActive(stack) ? displayName : ComponentUtil.mutable().m_7220_(displayName).m_130946_(" (").m_7220_((Component)ComponentUtil.translatable(Abilities.ACID_COAT.getTranslationKey())).m_130946_(")");
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag isAdvanced) {
        tooltip.addAll(ClientTextUtil.getItemInfoTooltip(stack));
        tooltip.add(ComponentUtil.emptyLine());
        if (GunbladeItem.GunbladeMode.from(stack) == GunbladeItem.GunbladeMode.MELEE) {
            Abilities.ACID_COAT.appendAbilityDescription(stack, tooltip);
        } else {
            this.appendGunStats(stack, tooltip);
        }
        this.appendLivingToolTooltip(stack, tooltip);
        tooltip.add(ComponentUtil.emptyLine());
        tooltip.add(ComponentUtil.emptyLine());
        tooltip.add((Component)ClientTextUtil.pressButtonTo(ClientTextUtil.getDefaultKey(), TextComponentUtil.getTooltipText("action.switch_mode")).m_130948_(TextStyles.DARK_GRAY));
        if (stack.m_41793_()) {
            tooltip.add(ComponentUtil.emptyLine());
        }
    }

    @Override
    public int getMaxNutrients(ItemStack stack) {
        return this.maxNutrients;
    }

    public boolean m_142207_(ItemStack stack, Slot slot, ClickAction action, Player player) {
        if (this.handleOverrideStackedOnOther(stack, slot, action, player)) {
            this.playSound(player, (SoundEvent)ModSoundEvents.FLESHKIN_EAT.get());
            return true;
        }
        return false;
    }

    public boolean m_142305_(ItemStack stack, ItemStack other, Slot slot, ClickAction action, Player player, SlotAccess access) {
        if (this.handleOverrideOtherStackedOnMe(stack, other, slot, action, player, access)) {
            this.playSound(player, (SoundEvent)ModSoundEvents.FLESHKIN_EAT.get());
            return true;
        }
        return false;
    }

    @Override
    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return super.canPerformAction(stack, toolAction) && this.hasNutrients(stack);
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return this.isValidEnchantment(stack, enchantment) && super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public boolean m_142522_(ItemStack stack) {
        return this.getNutrients(stack) < this.getMaxNutrients(stack);
    }

    public int m_142158_(ItemStack stack) {
        return Math.round(this.getNutrientsPct(stack) * 13.0f);
    }

    public int m_142159_(ItemStack stack) {
        return 9742422;
    }

    public boolean isDamageable(ItemStack stack) {
        return false;
    }

    public void setDamage(ItemStack stack, int damage) {
    }

    public int getDamage(ItemStack stack) {
        return 0;
    }

    public int getMaxDamage(ItemStack stack) {
        return 0;
    }

    public boolean m_41465_() {
        return false;
    }

    protected void playSound(Player player, SoundEvent soundEvent) {
        player.m_5496_(soundEvent, 0.8f, 0.8f + player.m_9236_().m_213780_().m_188501_() * 0.4f);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        super.initializeClient(consumer);
        consumer.accept(new IClientItemExtensions(){
            private final CausticGunbladeRenderer renderer = new CausticGunbladeRenderer();

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return this.renderer;
            }

            @Nullable
            public HumanoidModel.ArmPose getArmPose(LivingEntity entityLiving, InteractionHand hand, ItemStack itemStack) {
                if (GunbladeItem.GunbladeMode.from(itemStack) == GunbladeItem.GunbladeMode.RANGED) {
                    return HumanoidModel.ArmPose.CROSSBOW_HOLD;
                }
                return null;
            }
        });
    }

    protected void broadcastAnimation(ServerLevel level, Entity relatedEntity, ItemStack stack, TriggerableAnimation animation) {
        long id = GeoItem.getOrAssignId((ItemStack)stack, (ServerLevel)level);
        this.triggerAnim(relatedEntity, id, animation.controller(), animation.name());
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        Animations.registerControllers(this, controllers);
    }

    protected static final class Animations {
        static final String MAIN_CONTROLLER = "main";
        static final String ACID_COAT_CONTROLLER = "acid_blades";
        static final String AMMO_CONTROLLER = "ammo";
        static final RawAnimation IDLE_RANGED = RawAnimation.begin().thenPlay("idle_ranged");
        static final RawAnimation IDLE_MELEE = RawAnimation.begin().thenPlay("idle_melee");
        static final RawAnimation RANGED_TO_MELEE = RawAnimation.begin().thenPlay("ranged_to_melee").thenPlay("idle_melee");
        static final RawAnimation MELEE_TO_RANGED = RawAnimation.begin().thenPlay("melee_to_ranged").thenPlay("idle_ranged");
        static final RawAnimation COATED_BLADES = RawAnimation.begin().thenPlay("coated_blades");
        static final RawAnimation UNCOATED_BLADES = RawAnimation.begin().thenPlay("uncoated_blades");
        static final RawAnimation FULL_AMMO = RawAnimation.begin().thenPlay("full_ammo");
        static final RawAnimation HALF_AMMO = RawAnimation.begin().thenPlay("half_ammo");
        static final RawAnimation NO_AMMO = RawAnimation.begin().thenPlay("no_ammo");
        private static final List<TriggerableAnimation> TRIGGERABLE_ANIMATIONS = new ArrayList<TriggerableAnimation>();
        static final TriggerableAnimation SHOOT = Animations.register("main", "shoot", RawAnimation.begin().thenPlay("shoot"));
        static final TriggerableAnimation COAT_BLADES = Animations.register("main", "coat_blades", RawAnimation.begin().thenPlay("coat_blades"));

        private Animations() {
        }

        static <T extends CausticGunbladeItem> PlayState handleMain(AnimationState<T> state) {
            if (state.getController().isPlayingTriggeredAnimation()) {
                return PlayState.CONTINUE;
            }
            ItemStack itemStack = (ItemStack)state.getData(DataTickets.ITEMSTACK);
            GunbladeItem.GunbladeMode gunbladeMode = GunbladeItem.GunbladeMode.from(itemStack);
            if (gunbladeMode == GunbladeItem.GunbladeMode.MELEE) {
                return state.setAndContinue(RANGED_TO_MELEE);
            }
            return state.setAndContinue(MELEE_TO_RANGED);
        }

        static <T extends CausticGunbladeItem> PlayState handleAcidCoat(AnimationState<T> state) {
            ItemStack itemStack = (ItemStack)state.getData(DataTickets.ITEMSTACK);
            boolean hasCoatedBlades = Abilities.ACID_COAT.isActive(itemStack);
            return state.setAndContinue(hasCoatedBlades ? COATED_BLADES : UNCOATED_BLADES);
        }

        static <T extends CausticGunbladeItem> PlayState handleAmmo(AnimationState<T> state) {
            ItemStack itemStack = (ItemStack)state.getData(DataTickets.ITEMSTACK);
            CausticGunbladeItem item = (CausticGunbladeItem)itemStack.m_41720_();
            int ammo = item.getAmmo(itemStack);
            int maxAmmo = item.getMaxAmmo(itemStack);
            if (ammo <= 0) {
                return state.setAndContinue(NO_AMMO);
            }
            return state.setAndContinue(ammo < maxAmmo ? HALF_AMMO : FULL_AMMO);
        }

        static void registerControllers(CausticGunbladeItem animatable, AnimatableManager.ControllerRegistrar controllers) {
            AnimationController mainController = new AnimationController((GeoAnimatable)animatable, MAIN_CONTROLLER, 0, Animations::handleMain);
            Animations.registerTriggerableAnimations(mainController);
            controllers.add(new AnimationController[]{mainController});
            controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)animatable, ACID_COAT_CONTROLLER, 0, Animations::handleAcidCoat)});
            controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)animatable, AMMO_CONTROLLER, 0, Animations::handleAmmo)});
        }

        private static TriggerableAnimation register(String controller, String name, RawAnimation rawAnimation) {
            TriggerableAnimation animation = new TriggerableAnimation(controller, name, rawAnimation);
            TRIGGERABLE_ANIMATIONS.add(animation);
            return animation;
        }

        private static void registerTriggerableAnimations(AnimationController<?> controller) {
            for (TriggerableAnimation animation : TRIGGERABLE_ANIMATIONS) {
                if (!animation.controller().equals(controller.getName())) continue;
                controller.triggerableAnim(animation.name(), animation.rawAnimation());
            }
        }
    }

    protected static final class Abilities {
        public static final ItemAbility ACID_COAT = new ItemAbility(){
            static final String NAME = "acid_coat";
            static final String KEY = BiomancyMod.createRLString("acid_coat");
            static final String TIMESTAMP_KEY = "timestamp";

            @Override
            public String name() {
                return NAME;
            }

            @Override
            public boolean isActive(ItemStack stack) {
                CompoundTag tag = stack.m_41737_(KEY);
                return tag != null;
            }

            @Override
            public void setActive(ServerLevel level, ItemStack stack, LivingEntity itemOwner) {
                CompoundTag tag = stack.m_41698_(KEY);
                tag.m_128356_(TIMESTAMP_KEY, level.m_46467_());
            }

            @Override
            public void tick(Level level, ItemStack stack, LivingEntity itemOwner) {
                CompoundTag tag = stack.m_41737_(KEY);
                if (tag == null) {
                    return;
                }
                if (level.m_46467_() - tag.m_128454_(TIMESTAMP_KEY) > 200L) {
                    stack.m_41749_(KEY);
                }
            }

            @Override
            public void cancel(ServerLevel level, ItemStack stack, LivingEntity itemOwner) {
                stack.m_41749_(KEY);
            }
        };

        protected Abilities() {
        }
    }

    public static interface ItemAbility {
        public String name();

        public void setActive(ServerLevel var1, ItemStack var2, LivingEntity var3);

        public boolean isActive(ItemStack var1);

        public void tick(Level var1, ItemStack var2, LivingEntity var3);

        public void cancel(ServerLevel var1, ItemStack var2, LivingEntity var3);

        default public String getTranslationKey() {
            return TextComponentUtil.getTranslationKey("ability", this.name());
        }

        default public void appendAbilityDescription(ItemStack stack, List<Component> components) {
            String translationKey = this.getTranslationKey();
            components.add((Component)ComponentUtil.translatable(translationKey).m_130948_(TextStyles.GRAY));
            components.addAll(ClientTextUtil.splitLinesByNewLine((Component)ComponentUtil.translatable(translationKey + ".desc").m_130948_(TextStyles.DARK_GRAY)));
        }
    }
}

