/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.menu;

import com.github.elenterius.biomancy.BiomancyMod;
import com.github.elenterius.biomancy.api.nutrients.Nutrients;
import com.github.elenterius.biomancy.block.bioforge.BioForgeBlockEntity;
import com.github.elenterius.biomancy.block.bioforge.BioForgeStateData;
import com.github.elenterius.biomancy.crafting.recipe.BioForgeRecipe;
import com.github.elenterius.biomancy.crafting.recipe.IngredientStack;
import com.github.elenterius.biomancy.init.ModMenuTypes;
import com.github.elenterius.biomancy.init.ModSoundEvents;
import com.github.elenterius.biomancy.inventory.BehavioralInventory;
import com.github.elenterius.biomancy.menu.PlayerContainerMenu;
import com.github.elenterius.biomancy.menu.slot.FuelSlot;
import com.github.elenterius.biomancy.menu.slot.ISlotZone;
import com.github.elenterius.biomancy.menu.slot.OutputSlot;
import com.github.elenterius.biomancy.util.SoundUtil;
import com.github.elenterius.biomancy.util.fuel.FuelHandler;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.apache.logging.log4j.MarkerManager;

public class BioForgeMenu
extends PlayerContainerMenu {
    final ResultContainer resultContainer = new ResultContainer();
    final int resultSlotIndex;
    private final BehavioralInventory<?> fuelInventory;
    private final BioForgeStateData stateData;
    private int playerInvChanges;
    private final StackedContents itemCounter = new StackedContents();
    @Nullable
    private BioForgeRecipe selectedRecipe;
    private ContainerLevelAccess containerLevelAccess = ContainerLevelAccess.f_39287_;
    private long prevSoundTime;

    protected BioForgeMenu(int id, Inventory playerInventory, BehavioralInventory<?> fuelInventory, BioForgeStateData stateData) {
        super((MenuType)ModMenuTypes.BIO_FORGE.get(), id, playerInventory, 124, 137, 195);
        this.fuelInventory = fuelInventory;
        this.fuelInventory.m_5856_(playerInventory.f_35978_);
        this.stateData = stateData;
        this.m_38897_(new FuelSlot(fuelInventory, 0, 139, 53));
        this.resultSlotIndex = this.m_38897_((Slot)(BioForgeMenu)this.new CustomResultSlot((Player)playerInventory.f_35978_, (ResultContainer)this.resultContainer, (int)0, (int)196, (int)35)).f_40219_;
        this.m_38884_(stateData);
    }

    public BioForgeStateData getStateData() {
        return this.stateData;
    }

    public BioForgeMenu(int id, Inventory playerInventory, BehavioralInventory<?> fuelInventory, BioForgeStateData stateData, ContainerLevelAccess containerLevelAccess) {
        this(id, playerInventory, fuelInventory, stateData);
        this.containerLevelAccess = containerLevelAccess;
    }

    public static BioForgeMenu createClientMenu(int screenId, Inventory playerInventory, FriendlyByteBuf buffer) {
        BioForgeStateData stateData;
        BehavioralInventory fuelInventory = BehavioralInventory.createClientContents(1);
        BlockEntity blockEntity = playerInventory.f_35978_.m_9236_().m_7702_(buffer.m_130135_());
        if (blockEntity instanceof BioForgeBlockEntity) {
            BioForgeBlockEntity bioForge = (BioForgeBlockEntity)blockEntity;
            stateData = bioForge.getStateData();
        } else {
            FuelHandler fuelHandler = FuelHandler.createNutrientFuelHandler(1000, () -> {});
            stateData = new BioForgeStateData(fuelHandler);
        }
        return new BioForgeMenu(screenId, playerInventory, fuelInventory, stateData);
    }

    @Override
    protected void onPlayerMainInventoryChanged(Inventory inventory) {
        Player player;
        if (!inventory.f_35978_.m_9236_().f_46443_ && (player = inventory.f_35978_) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.trackPlayerInvChanges(serverPlayer, inventory);
        }
    }

    private void trackPlayerInvChanges(ServerPlayer serverPlayer, Inventory inventory) {
        if (this.playerInvChanges != inventory.m_36072_()) {
            this.countPlayerInvItems(serverPlayer, inventory);
            this.playerInvChanges = inventory.m_36072_();
        }
    }

    private void countPlayerInvItems(ServerPlayer serverPlayer, Inventory inventory) {
        this.itemCounter.m_36453_();
        inventory.m_36010_(this.itemCounter);
        this.updateResultSlot(serverPlayer);
    }

    private void updateResultSlot(ServerPlayer serverPlayer) {
        ItemStack resultStack = ItemStack.f_41583_;
        BioForgeRecipe recipe = this.getSelectedRecipe();
        if (recipe != null && this.resultContainer.m_40135_(serverPlayer.m_9236_(), serverPlayer, (Recipe)recipe) && this.canCraft((Player)serverPlayer, recipe)) {
            resultStack = recipe.m_8043_(serverPlayer.m_9236_().m_9598_()).m_41777_();
        }
        this.resultContainer.m_6836_(0, resultStack);
        this.m_150404_(0, resultStack);
        this.m_38946_();
    }

    @Nullable
    public BioForgeRecipe getSelectedRecipe() {
        return this.selectedRecipe;
    }

    public void setSelectedRecipe(@Nullable BioForgeRecipe recipe, ServerPlayer serverPlayer) {
        this.selectedRecipe = recipe;
        this.countPlayerInvItems(serverPlayer, serverPlayer.m_150109_());
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.resultContainer.m_6211_();
        this.fuelInventory.m_5785_(player);
    }

    public boolean m_5882_(ItemStack stack, Slot slot) {
        return slot.f_40218_ != this.resultContainer && super.m_5882_(stack, slot);
    }

    public boolean m_6875_(Player player) {
        return this.fuelInventory.m_6542_(player);
    }

    public float getFuelAmountNormalized() {
        return Mth.m_14036_((float)((float)this.getFuelAmount() / 1000.0f), (float)0.0f, (float)1.0f);
    }

    public int getFuelAmount() {
        return this.stateData.fuelHandler.getFuelAmount();
    }

    public int getMaxFuelAmount() {
        return 1000;
    }

    public boolean isResultEmpty() {
        return this.resultContainer.m_7983_();
    }

    public ItemStack m_7648_(Player player, int index) {
        boolean successfulTransfer;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (!slot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack stackInSlot = slot.m_7993_();
        ItemStack copyOfStack = stackInSlot.m_41777_();
        SlotZone slotZone = SlotZone.getZoneFromIndex(index);
        switch (slotZone) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case OUTPUT_ZONE: {
                boolean bl = this.mergeIntoPlayerMainInventory(stackInSlot);
                break;
            }
            case FUEL_ZONE: {
                boolean bl = this.mergeIntoEither(SlotZone.PLAYER_MAIN_INVENTORY, SlotZone.PLAYER_HOTBAR, stackInSlot, false);
                break;
            }
            case PLAYER_HOTBAR: 
            case PLAYER_MAIN_INVENTORY: {
                boolean bl = successfulTransfer = this.mergeIntoFuelZone(stackInSlot) || this.mergeIntoPlayerZone(slotZone, stackInSlot);
            }
        }
        if (!successfulTransfer) {
            return ItemStack.f_41583_;
        }
        if (slotZone == SlotZone.OUTPUT_ZONE) {
            stackInSlot.m_41720_().m_7836_(stackInSlot, player.m_9236_(), player);
            slot.m_40234_(stackInSlot, copyOfStack);
        }
        if (stackInSlot.m_41619_()) {
            slot.m_5852_(ItemStack.f_41583_);
        } else {
            slot.m_6654_();
        }
        if (stackInSlot.m_41613_() == copyOfStack.m_41613_()) {
            BiomancyMod.LOGGER.warn(MarkerManager.getMarker((String)"BioForgeMenu"), "Stack transfer failed in an unexpected way!");
            return ItemStack.f_41583_;
        }
        slot.m_142406_(player, stackInSlot);
        return copyOfStack;
    }

    private boolean mergeIntoFuelZone(ItemStack stackInSlot) {
        if (Nutrients.isValidFuel(stackInSlot)) {
            return this.mergeInto(SlotZone.FUEL_ZONE, stackInSlot, true);
        }
        return false;
    }

    private boolean mergeIntoPlayerZone(SlotZone slotZone, ItemStack stackInSlot) {
        if (slotZone == SlotZone.PLAYER_HOTBAR) {
            return this.mergeInto(SlotZone.PLAYER_MAIN_INVENTORY, stackInSlot, false);
        }
        return this.mergeInto(SlotZone.PLAYER_HOTBAR, stackInSlot, false);
    }

    private boolean mergeIntoPlayerMainInventory(ItemStack stackInSlot) {
        return this.m_38903_(stackInSlot, SlotZone.PLAYER_HOTBAR.getFirstIndex(), SlotZone.PLAYER_MAIN_INVENTORY.getLastIndexPlusOne(), true);
    }

    public static BioForgeMenu createServerMenu(int screenId, Inventory playerInventory, BehavioralInventory<?> fuelInventory, BioForgeStateData stateData, ContainerLevelAccess containerLevelAccess) {
        return new BioForgeMenu(screenId, playerInventory, fuelInventory, stateData, containerLevelAccess);
    }

    private boolean canCraft(Player player, @Nullable BioForgeRecipe recipe) {
        if (recipe == null || this.getFuelAmount() < recipe.getCraftingCostNutrients() || !recipe.isCraftable(this.itemCounter)) {
            return false;
        }
        Inventory inventory = player.m_150109_();
        List<IngredientStack> ingredients = recipe.getIngredientQuantities();
        int[] countedIngredients = new int[ingredients.size()];
        block0: for (int idx = 0; idx < inventory.f_35974_.size(); ++idx) {
            ItemStack foundStack = (ItemStack)inventory.f_35974_.get(idx);
            if (foundStack.m_41619_()) continue;
            for (int i = 0; i < ingredients.size(); ++i) {
                if (!ingredients.get(i).testItem(foundStack)) continue;
                int n = i;
                countedIngredients[n] = countedIngredients[n] + foundStack.m_41613_();
                continue block0;
            }
        }
        for (int i = 0; i < ingredients.size(); ++i) {
            int requiredCount = ingredients.get(i).count();
            if (countedIngredients[i] >= requiredCount) continue;
            return false;
        }
        return true;
    }

    private void consumeCraftingIngredients(Player player, BioForgeRecipe recipe) {
        List<IngredientStack> ingredients = recipe.getIngredientQuantities();
        int[] ingredientCost = new int[ingredients.size()];
        for (int i = 0; i < ingredients.size(); ++i) {
            ingredientCost[i] = ingredients.get(i).count();
        }
        Inventory inventory = player.m_150109_();
        block1: for (int idx = 0; idx < inventory.f_35974_.size(); ++idx) {
            ItemStack foundStack = (ItemStack)inventory.f_35974_.get(idx);
            if (foundStack.m_41619_()) continue;
            for (int i = 0; i < ingredients.size(); ++i) {
                int remainingCost = ingredientCost[i];
                if (remainingCost <= 0 || !ingredients.get(i).testItem(foundStack)) continue;
                int amount = Math.min(remainingCost, foundStack.m_41613_());
                foundStack.m_41774_(amount);
                int n = i;
                ingredientCost[n] = ingredientCost[n] - amount;
                continue block1;
            }
        }
        inventory.m_6596_();
        this.stateData.fuelHandler.addFuelAmount(-recipe.getCraftingCostNutrients());
    }

    private class CustomResultSlot
    extends OutputSlot {
        private final Player player;
        private int removeCount;

        public CustomResultSlot(Player player, ResultContainer container, int index, int x, int y) {
            super((Container)container, index, x, y);
            this.player = player;
        }

        public ItemStack m_6201_(int amount) {
            if (this.m_6657_()) {
                this.removeCount += Math.min(amount, this.m_7993_().m_41613_());
            }
            return super.m_6201_(amount);
        }

        protected void m_7169_(ItemStack stack, int amount) {
            this.removeCount += amount;
            this.m_5845_(stack);
        }

        protected void m_6405_(int craftedItems) {
            this.removeCount += craftedItems;
        }

        protected void m_5845_(ItemStack stack) {
            if (this.removeCount > 0) {
                stack.m_41678_(this.player.m_9236_(), this.player, this.removeCount);
            }
            this.removeCount = 0;
        }

        public void m_142406_(Player player, ItemStack stack) {
            if (player.m_9236_().f_46443_) {
                this.m_6654_();
                return;
            }
            BioForgeRecipe recipe = BioForgeMenu.this.getSelectedRecipe();
            if (recipe != null) {
                BioForgeMenu.this.consumeCraftingIngredients(player, recipe);
            }
            this.m_5845_(stack);
            BioForgeMenu.this.onPlayerMainInventoryChanged(player.m_150109_());
            BioForgeMenu.this.containerLevelAccess.m_39292_((level, pos) -> {
                long time = level.m_46467_();
                if (BioForgeMenu.this.prevSoundTime != time) {
                    SoundUtil.broadcastBlockSound((ServerLevel)level, pos, ModSoundEvents.UI_BIO_FORGE_TAKE_RESULT);
                    BioForgeMenu.this.prevSoundTime = time;
                }
            });
            this.m_6654_();
        }
    }

    public static enum SlotZone implements ISlotZone
    {
        PLAYER_HOTBAR(0, 9),
        PLAYER_MAIN_INVENTORY(SlotZone.PLAYER_HOTBAR.lastIndexPlus1, 27),
        FUEL_ZONE(SlotZone.PLAYER_MAIN_INVENTORY.lastIndexPlus1, 1),
        OUTPUT_ZONE(SlotZone.FUEL_ZONE.lastIndexPlus1, 1);

        public final int firstIndex;
        public final int slotCount;
        public final int lastIndexPlus1;

        private SlotZone(int firstIndex, int numberOfSlots) {
            this.firstIndex = firstIndex;
            this.slotCount = numberOfSlots;
            this.lastIndexPlus1 = firstIndex + numberOfSlots;
        }

        public static SlotZone getZoneFromIndex(int slotIndex) {
            for (SlotZone slotZone : SlotZone.values()) {
                if (slotIndex < slotZone.firstIndex || slotIndex >= slotZone.lastIndexPlus1) continue;
                return slotZone;
            }
            throw new IndexOutOfBoundsException("Unexpected slotIndex");
        }

        @Override
        public int getFirstIndex() {
            return this.firstIndex;
        }

        @Override
        public int getLastIndexPlusOne() {
            return this.lastIndexPlus1;
        }

        @Override
        public int getSlotCount() {
            return this.slotCount;
        }
    }
}

