/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.network;

import com.github.elenterius.biomancy.crafting.recipe.BioForgeRecipe;
import com.github.elenterius.biomancy.init.ModRecipes;
import com.github.elenterius.biomancy.menu.BioForgeMenu;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.network.NetworkEvent;

public class BioForgeRecipeMessage {
    public final ResourceLocation id;
    public final int containerId;

    public BioForgeRecipeMessage(int containerId, ResourceLocation recipeId) {
        this.id = recipeId;
        this.containerId = containerId;
    }

    public static BioForgeRecipeMessage decode(FriendlyByteBuf buffer) {
        int containerId = buffer.m_130242_();
        ResourceLocation recipeId = buffer.m_130281_();
        return new BioForgeRecipeMessage(containerId, recipeId);
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.containerId);
        buffer.m_130085_(this.id);
    }

    public static void handle(BioForgeRecipeMessage packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            AbstractContainerMenu patt1417$temp;
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            if (sender != null && !sender.m_5833_() && (patt1417$temp = sender.f_36096_) instanceof BioForgeMenu) {
                BioForgeMenu menu = (BioForgeMenu)patt1417$temp;
                if (menu.f_38840_ == packet.containerId) {
                    RecipeManager recipeManager = sender.m_9236_().m_7465_();
                    Map recipes = recipeManager.m_44054_((RecipeType)ModRecipes.BIO_FORGING_RECIPE_TYPE.get());
                    BioForgeRecipe recipe = (BioForgeRecipe)recipes.get(packet.id);
                    menu.setSelectedRecipe(recipe, sender);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

