/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.network;

import com.github.elenterius.biomancy.item.KeyPressListener;
import com.google.common.primitives.UnsignedBytes;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class KeyPressMessage {
    public final byte slotIndex;
    public final byte flag;

    public KeyPressMessage(int slotIndex, byte flag) {
        this.slotIndex = UnsignedBytes.checkedCast((long)slotIndex);
        this.flag = flag;
    }

    public KeyPressMessage(byte slotIndex, byte flag) {
        this.slotIndex = slotIndex;
        this.flag = flag;
    }

    public static void handle(KeyPressMessage packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null) {
                ServerLevel level = player.m_284548_();
                KeyPressListener.onReceiveKeybindingPacket(level, player, UnsignedBytes.toInt((byte)packet.slotIndex), packet.flag);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public static KeyPressMessage decode(FriendlyByteBuf byteBuf) {
        byte slotIndex = byteBuf.readByte();
        byte flag = byteBuf.readByte();
        return new KeyPressMessage(slotIndex, flag);
    }

    public void encode(FriendlyByteBuf byteBuf) {
        byteBuf.writeByte((int)this.slotIndex);
        byteBuf.writeByte((int)this.flag);
    }
}

