/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.network;

import com.github.elenterius.biomancy.BiomancyMod;
import com.github.elenterius.biomancy.crafting.recipe.BioForgeRecipe;
import com.github.elenterius.biomancy.network.BioForgeRecipeMessage;
import com.github.elenterius.biomancy.network.KeyPressMessage;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;

public final class ModNetworkHandler {
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel SIMPLE_NETWORK_CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)BiomancyMod.createRL("main"), () -> "1", "1"::equals, "1"::equals);

    private ModNetworkHandler() {
    }

    public static void sendKeyBindPressToServer(InteractionHand hand, byte flag) {
        EquipmentSlot slot = hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND;
        ModNetworkHandler.sendKeyBindPressToServer(slot, flag);
    }

    public static void sendKeyBindPressToServer(EquipmentSlot slot, byte flag) {
        SIMPLE_NETWORK_CHANNEL.sendToServer((Object)new KeyPressMessage(slot.m_20750_(), flag));
    }

    public static void sendKeyBindPressToServer(int slotIndex, byte flag) {
        SIMPLE_NETWORK_CHANNEL.sendToServer((Object)new KeyPressMessage(slotIndex, flag));
    }

    public static void sendBioForgeRecipeToServer(int containerId, BioForgeRecipe recipe) {
        SIMPLE_NETWORK_CHANNEL.sendToServer((Object)new BioForgeRecipeMessage(containerId, recipe.m_6423_()));
    }

    public static void register() {
        int id = -1;
        SIMPLE_NETWORK_CHANNEL.registerMessage(++id, KeyPressMessage.class, KeyPressMessage::encode, KeyPressMessage::decode, KeyPressMessage::handle);
        SIMPLE_NETWORK_CHANNEL.registerMessage(++id, BioForgeRecipeMessage.class, BioForgeRecipeMessage::encode, BioForgeRecipeMessage::decode, BioForgeRecipeMessage::handle);
    }
}

