/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.ownable;

import com.github.elenterius.biomancy.block.ownable.OwnableBlockEntity;
import com.github.elenterius.biomancy.client.util.ClientTextUtil;
import com.github.elenterius.biomancy.ownable.Ownable;
import com.github.elenterius.biomancy.permission.UserType;
import com.github.elenterius.biomancy.styles.TextComponentUtil;
import com.github.elenterius.biomancy.util.ComponentUtil;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;

public interface OwnableEntityBlock
extends EntityBlock {
    public static final String NBT_KEY_OWNER = "OwnerUUID";
    public static final String NBT_KEY_USER_LIST = "UserList";
    public static final String NBT_KEY_USER = "UserUUID";

    public static void setupBlockEntityOwner(Level level, Ownable ownable, @Nullable LivingEntity placer, ItemStack stack) {
        boolean containsOwner;
        if (placer == null) {
            return;
        }
        CompoundTag entityData = BlockItem.m_186336_((ItemStack)stack);
        boolean bl = containsOwner = entityData != null && entityData.m_128403_(NBT_KEY_OWNER);
        if (!containsOwner && !ownable.hasOwner()) {
            ownable.setOwner(placer.m_20148_());
        }
    }

    public static void dropForCreativePlayer(Level worldIn, Block block, BlockPos pos, Player player) {
        BlockEntity blockEntity;
        if (!worldIn.m_5776_() && player.m_7500_() && worldIn.m_46469_().m_46207_(GameRules.f_46136_) && (blockEntity = worldIn.m_7702_(pos)) instanceof OwnableBlockEntity) {
            OwnableBlockEntity blockEntity2 = (OwnableBlockEntity)blockEntity;
            ItemStack stack = new ItemStack((ItemLike)block);
            blockEntity2.m_187476_(stack);
            if (stack.m_41782_()) {
                ItemEntity itemEntity = new ItemEntity(worldIn, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, stack);
                itemEntity.m_32060_();
                worldIn.m_7967_((Entity)itemEntity);
            }
        }
    }

    public static void appendUserListToTooltip(ItemStack stack, List<Component> tooltip) {
        CompoundTag entityData = BlockItem.m_186336_((ItemStack)stack);
        if (entityData == null) {
            return;
        }
        OwnableEntityBlock.appendUserListToTooltip(entityData, tooltip);
    }

    public static void appendUserListToTooltip(CompoundTag entityData, List<Component> tooltip) {
        String ownerName = "NULL";
        if (entityData.m_128403_(NBT_KEY_OWNER)) {
            ownerName = ClientTextUtil.tryToGetPlayerNameOnClientSide(entityData.m_128342_(NBT_KEY_OWNER));
        }
        tooltip.add(ComponentUtil.emptyLine());
        tooltip.add((Component)TextComponentUtil.getTooltipText("owner", ComponentUtil.literal(ownerName).m_130940_(ChatFormatting.WHITE)).m_130940_(ChatFormatting.GRAY));
        if (entityData.m_128441_(NBT_KEY_USER_LIST)) {
            ListTag nbtList = entityData.m_128437_(NBT_KEY_USER_LIST, 10);
            tooltip.add((Component)ComponentUtil.literal("Users: ").m_130940_(ChatFormatting.GRAY));
            int limit = Screen.m_96637_() ? Math.min(5, nbtList.size()) : nbtList.size();
            for (int i = 0; i < limit; ++i) {
                CompoundTag userNbt = nbtList.m_128728_(i);
                String userName = ClientTextUtil.tryToGetPlayerNameOnClientSide(userNbt.m_128342_(NBT_KEY_USER));
                UserType level = UserType.deserialize(userNbt);
                tooltip.add((Component)ComponentUtil.literal(String.format(" - %s (%s)", userName, level.name().toLowerCase(Locale.ROOT))).m_130940_(ChatFormatting.GRAY));
            }
            int remainder = nbtList.size() - limit;
            if (remainder > 0) {
                tooltip.add((Component)ClientTextUtil.pressButtonTo(ClientTextUtil.getCtrlKey(), "show " + remainder + " more users..."));
            }
        }
    }
}

