/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.ownable;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;

public interface OwnableItem {
    public static final String NBT_KEY = "OwnerUUID";

    default public Optional<UUID> getOwner(ItemStack stack) {
        CompoundTag nbt = stack.m_41784_();
        if (nbt.m_128403_(NBT_KEY)) {
            return Optional.of(nbt.m_128342_(NBT_KEY));
        }
        return Optional.empty();
    }

    default public void setOwner(ItemStack stack, UUID uuid) {
        stack.m_41784_().m_128362_(NBT_KEY, uuid);
    }

    default public void removeOwner(ItemStack stack) {
        stack.m_41784_().m_128473_(NBT_KEY);
    }

    default public boolean hasOwner(ItemStack stack) {
        return stack.m_41784_().m_128403_(NBT_KEY);
    }

    default public boolean isOwner(ItemStack stack, UUID uuid) {
        return this.getOwner(stack).map(value -> value.equals(uuid)).orElse(false);
    }
}

