/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.ownable;

import com.github.elenterius.biomancy.ownable.Ownable;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public interface OwnableMob
extends Ownable,
OwnableEntity {
    public Optional<Player> getOwnerAsPlayer();

    public Optional<LivingEntity> getOwnerAsEntity();

    @Nullable
    default public UUID m_21805_() {
        return this.getOptionalOwnerUUID().orElse(null);
    }

    @Nullable
    default public LivingEntity m_269323_() {
        return this.getOwnerAsEntity().orElse(null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    default public boolean shouldAttackEntity(LivingEntity target, LivingEntity owner) {
        if (target.m_20148_().equals(owner.m_20148_())) {
            return false;
        }
        if (target instanceof OwnableMob) {
            OwnableMob mob = (OwnableMob)target;
            if (mob.isOwner((Entity)owner)) return false;
            return true;
        }
        if (target instanceof OwnableEntity) {
            OwnableEntity entity = (OwnableEntity)target;
            if (owner.m_20148_().equals(entity.m_21805_())) return false;
            return true;
        }
        if (!(target instanceof Player)) return true;
        Player targetPlayer = (Player)target;
        if (!(owner instanceof Player)) return true;
        Player ownerPlayer = (Player)owner;
        if (!ownerPlayer.m_7099_(targetPlayer)) return false;
        return true;
    }

    public boolean tryToReturnIntoPlayerInventory();
}

