/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.serum;

import com.github.elenterius.biomancy.client.util.ClientTextUtil;
import com.github.elenterius.biomancy.init.ModMobEffects;
import com.github.elenterius.biomancy.serum.BasicSerum;
import com.github.elenterius.biomancy.styles.TextStyles;
import com.github.elenterius.biomancy.util.ComponentUtil;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.StringUtil;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class AdrenalineSerum
extends BasicSerum {
    public static final int DURATION = 3000;
    public static final int AMPLIFIER = 1;

    public AdrenalineSerum(int colorIn) {
        super(colorIn);
    }

    @Override
    public void affectEntity(ServerLevel level, CompoundTag tag, @Nullable LivingEntity source, LivingEntity target) {
        this.addStatusEffect(target);
    }

    @Override
    public void affectPlayerSelf(CompoundTag tag, ServerPlayer targetSelf) {
        this.addStatusEffect((LivingEntity)targetSelf);
    }

    private void addStatusEffect(LivingEntity target) {
        int duration = 3000;
        MobEffectInstance effectInstance = target.m_21124_((MobEffect)ModMobEffects.ADRENAL_FATIGUE.get());
        if (effectInstance != null) {
            duration -= Math.min(effectInstance.m_19557_() / 2, 600);
            target.m_21195_((MobEffect)ModMobEffects.ADRENAL_FATIGUE.get());
        }
        target.m_7292_(new MobEffectInstance((MobEffect)ModMobEffects.ADRENALINE_RUSH.get(), duration, 1));
    }

    @Override
    public void appendTooltip(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flagIn) {
        if (ClientTextUtil.showExtraInfo(tooltip)) {
            tooltip.add((Component)ComponentUtil.translatable(this.getDescriptionTranslationKey()).m_130948_(TextStyles.LORE));
        }
        this.addEffectToClientTooltip(tooltip, (MobEffect)ModMobEffects.ADRENALINE_RUSH.get(), 1, 3000);
    }

    public void addEffectToClientTooltip(List<Component> tooltips, MobEffect effect, int amplifier, int duration) {
        MutableComponent effectText = ComponentUtil.translatable(effect.m_19481_());
        if (amplifier > 0) {
            effectText = ComponentUtil.translatable("potion.withAmplifier", effectText, ComponentUtil.translatable("potion.potency." + amplifier));
        }
        if (duration > 20) {
            effectText = ComponentUtil.translatable("potion.withDuration", effectText, StringUtil.m_14404_((int)duration));
        }
        tooltips.add((Component)effectText.m_130940_(effect.m_19483_().m_19497_()));
        Map effectModifiers = effect.m_19485_();
        if (!effectModifiers.isEmpty()) {
            tooltips.add(ComponentUtil.emptyLine());
            for (Map.Entry entry : effectModifiers.entrySet()) {
                AttributeModifier modifier = (AttributeModifier)entry.getValue();
                AttributeModifier.Operation operation = modifier.m_22217_();
                double value = effect.m_7048_(amplifier, modifier);
                double amount = operation != AttributeModifier.Operation.MULTIPLY_BASE && operation != AttributeModifier.Operation.MULTIPLY_TOTAL ? value : value * 100.0;
                MutableComponent attributeText = ComponentUtil.translatable(((Attribute)entry.getKey()).m_22087_());
                if (value > 0.0) {
                    tooltips.add((Component)ComponentUtil.translatable("attribute.modifier.plus." + operation.m_22235_(), ItemStack.f_41584_.format(amount), attributeText).m_130940_(ChatFormatting.BLUE));
                    continue;
                }
                if (!(value < 0.0)) continue;
                tooltips.add((Component)ComponentUtil.translatable("attribute.modifier.take." + operation.m_22235_(), ItemStack.f_41584_.format(amount *= -1.0), attributeText).m_130940_(ChatFormatting.RED));
            }
        }
    }
}

