/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.serum;

import com.github.elenterius.biomancy.init.tags.ModMobEffectTags;
import com.github.elenterius.biomancy.integration.ModsCompatHandler;
import com.github.elenterius.biomancy.mixin.ZombieVillagerMixinAccessor;
import com.github.elenterius.biomancy.serum.BasicSerum;
import com.github.elenterius.biomancy.util.MobUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.ForgeEventFactory;

public class CleansingSerum
extends BasicSerum {
    public CleansingSerum(int color) {
        super(color);
    }

    @Override
    public void affectEntity(ServerLevel level, CompoundTag tag, @Nullable LivingEntity source, LivingEntity target) {
        this.clearPotionEffects(target);
        this.clearAbsorption(target);
        this.resetPehkuiSize(target);
        if (target instanceof ZombieVillager) {
            if (ForgeEventFactory.canLivingConvert((LivingEntity)target, (EntityType)EntityType.f_20492_, timer -> {})) {
                ((ZombieVillagerMixinAccessor)target).biomancy$cureZombie((ServerLevel)target.m_9236_());
            }
        } else if (target instanceof WitherSkeleton) {
            WitherSkeleton skeleton = (WitherSkeleton)target;
            MobUtil.convertMobTo((ServerLevel)target.m_9236_(), skeleton, EntityType.f_20524_);
        }
        if (target instanceof AgeableMob) {
            AgeableMob ageableMob = (AgeableMob)target;
            MobUtil.removeForcedAge(ageableMob);
        }
        if (target instanceof Player) {
            Player player = (Player)target;
            player.m_36399_(40.0f);
        }
    }

    private void resetPehkuiSize(LivingEntity target) {
        ModsCompatHandler.getPehkuiHelper().resetSize(target);
    }

    @Override
    public void affectPlayerSelf(CompoundTag tag, ServerPlayer targetSelf) {
        this.clearPotionEffects((LivingEntity)targetSelf);
        this.clearAbsorption((LivingEntity)targetSelf);
        this.resetPehkuiSize((LivingEntity)targetSelf);
        targetSelf.m_36399_(40.0f);
    }

    private void clearPotionEffects(LivingEntity target) {
        this.removeAllEffects(target);
    }

    private void removeAllEffects(LivingEntity target) {
        List<MobEffectInstance> activeEffects = List.copyOf(target.m_21220_());
        for (MobEffectInstance activeEffect : activeEffects) {
            MobEffect effect = activeEffect.m_19544_();
            if (ModMobEffectTags.isNotRemovableWithCleansingSerum(effect)) continue;
            target.m_21195_(effect);
        }
    }

    private void clearAbsorption(LivingEntity target) {
        target.m_7911_(0.0f);
    }
}

