/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.statuseffect;

import com.github.elenterius.biomancy.init.ModMobEffects;
import com.github.elenterius.biomancy.init.tags.ModItemTags;
import com.github.elenterius.biomancy.init.tags.ModMobEffectTags;
import com.github.elenterius.biomancy.item.armor.AcolyteArmorItem;
import javax.annotation.Nullable;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="biomancy", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class StatusEffectHandler {
    private StatusEffectHandler() {
    }

    @SubscribeEvent
    public static void onEffectRemoval(MobEffectEvent.Remove event) {
        if (event.getEntity().m_9236_().f_46443_) {
            return;
        }
        if (event.getEffect() == ModMobEffects.ESSENCE_ANEMIA.get() && ModMobEffectTags.isNotRemovableWithCleansingSerum((MobEffect)ModMobEffects.ESSENCE_ANEMIA.get())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onEffectExpiry(MobEffectEvent.Expired event) {
        MobEffectInstance effectInstance;
        if (!event.getEntity().m_9236_().f_46443_ && (effectInstance = event.getEffectInstance()) != null && effectInstance.m_19544_() == ModMobEffects.ADRENALINE_RUSH.get()) {
            event.getEntity().m_7292_(new MobEffectInstance((MobEffect)ModMobEffects.ADRENAL_FATIGUE.get(), 3000, 1));
        }
    }

    @Nullable
    public static MobEffectInstance createAdrenalFatigueEffectFrom(@Nullable MobEffectInstance effectInstance) {
        int duration = 3000;
        if (effectInstance != null) {
            duration -= effectInstance.m_19557_();
        }
        if (duration > 0) {
            return new MobEffectInstance((MobEffect)ModMobEffects.ADRENAL_FATIGUE.get(), duration, 1);
        }
        return null;
    }

    @SubscribeEvent
    public static void onFoodEaten(LivingEntityUseItemEvent.Finish event) {
        ItemStack stack;
        if (!event.getEntity().m_9236_().f_46443_ && (stack = event.getItem()).m_41614_() && stack.m_204117_(ModItemTags.SUGARS)) {
            FoodProperties food = stack.m_41720_().m_41473_();
            StatusEffectHandler.reduceAdrenalFatigue(food != null ? food.m_38744_() : 0, event.getEntity());
        }
    }

    public static void reduceAdrenalFatigue(int nutrition, LivingEntity livingEntity) {
        MobEffectInstance effectInstance = livingEntity.m_21124_((MobEffect)ModMobEffects.ADRENAL_FATIGUE.get());
        if (effectInstance != null) {
            int duration = effectInstance.m_19557_() - (nutrition * nutrition / 2 + 4) * 20;
            int amplifier = effectInstance.m_19564_();
            boolean ambient = effectInstance.m_19571_();
            boolean visible = effectInstance.m_19572_();
            boolean showIcon = effectInstance.m_19575_();
            StatusEffectHandler.overrideMobEffect(livingEntity, new MobEffectInstance((MobEffect)ModMobEffects.ADRENAL_FATIGUE.get(), duration, amplifier, ambient, visible, showIcon));
        }
    }

    public static void overrideMobEffect(LivingEntity livingEntity, MobEffectInstance newMobEffectInstance) {
        livingEntity.m_21195_(newMobEffectInstance.m_19544_());
        livingEntity.m_7292_(newMobEffectInstance);
    }

    public static boolean canApplySplashEffectIfAllowed(MobEffect effect, LivingEntity target) {
        MobEffectCategory category = effect.m_19483_();
        if (target.m_21222_()) {
            if (effect == MobEffects.f_19601_) {
                category = MobEffectCategory.HARMFUL;
            } else if (effect == MobEffects.f_19602_) {
                category = MobEffectCategory.BENEFICIAL;
            }
        }
        if (category == MobEffectCategory.HARMFUL) {
            int resistProbability = 0;
            for (ItemStack itemStack : target.m_6168_()) {
                AcolyteArmorItem armor;
                Item item = itemStack.m_41720_();
                if (!(item instanceof AcolyteArmorItem) || !(armor = (AcolyteArmorItem)item).hasNutrients(itemStack)) continue;
                resistProbability += 15;
            }
            if (resistProbability > 0) {
                return target.m_217043_().m_188503_(100) >= resistProbability;
            }
        }
        return true;
    }
}

