/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.util;

import com.github.elenterius.biomancy.mixin.BiomeAccessor;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;

public class ClimateUtil {
    public static final float MIN_TEMP = -0.7f;
    public static final float MAX_TEMP = 2.0f;
    public static final float TEMP_DIFF = 2.7f;

    public static float rescale(float minecraftTemperature) {
        return (minecraftTemperature - -0.7f) / 2.7f;
    }

    public static boolean isFreezing(float minecraftTemperature) {
        return (double)minecraftTemperature < 0.15;
    }

    public static float convertMinecraftTemperatureToCelsius(float minecraftTemperature) {
        return 27.8f * minecraftTemperature - 4.17f;
    }

    public static float getTemperature(Level level, BlockPos pos) {
        Biome biome = (Biome)level.m_204166_(pos).get();
        return ClimateUtil.getTemperature(biome, pos);
    }

    public static float getTemperature(Biome biome, BlockPos pos) {
        return ((BiomeAccessor)biome).biomancy$getTemperature(pos);
    }

    public static float getHumidity(Biome biome) {
        return biome.getModifiedClimateSettings().f_47683_();
    }
}

