/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public class IntermediaryKeyCache<K, V> {
    private final Function<K, Integer> intermediaryKeyFunc;
    private final Map<K, V> accessMap = new HashMap();
    private final Map<Integer, V> valueCache = new HashMap<Integer, V>();

    public IntermediaryKeyCache(Function<K, Integer> intermediaryKeyFunc) {
        this.intermediaryKeyFunc = intermediaryKeyFunc;
    }

    @Nullable
    public V put(K key, V value) {
        this.valueCache.put(this.intermediaryKeyFunc.apply(key), value);
        return this.accessMap.put(key, value);
    }

    public V computeIfAbsent(K key, Function<K, V> computeValue) {
        if (this.accessMap.containsKey(key)) {
            return this.accessMap.get(key);
        }
        Object value = this.valueCache.computeIfAbsent(this.intermediaryKeyFunc.apply(key), (? super K intermediaryKey) -> computeValue.apply(key));
        this.accessMap.put(key, value);
        return (V)value;
    }

    @Nullable
    public V get(K key) {
        return this.accessMap.get(key);
    }

    public Optional<V> getOptional(K key) {
        return Optional.ofNullable(this.accessMap.get(key));
    }
}

