/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.util;

import com.github.elenterius.biomancy.block.property.MobSoundType;
import com.github.elenterius.biomancy.mixin.LivingEntityAccessor;
import com.github.elenterius.biomancy.mixin.MobEntityAccessor;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraftforge.registries.ForgeRegistries;

public final class MobSoundUtil {
    private MobSoundUtil() {
    }

    public static SoundEvent getSoundFallbackFor(MobSoundType soundType) {
        return switch (soundType) {
            default -> throw new IncompatibleClassChangeError();
            case MobSoundType.AMBIENT -> SoundEvents.f_12320_;
            case MobSoundType.HURT -> SoundEvents.f_11915_;
            case MobSoundType.DEATH -> SoundEvents.f_11910_;
        };
    }

    public static CompoundTag saveSounds(LivingEntity livingEntity) {
        CompoundTag tag = new CompoundTag();
        LivingEntityAccessor livingEntityAccessor = (LivingEntityAccessor)livingEntity;
        MobSoundUtil.putSound(tag, MobSoundType.DEATH, livingEntityAccessor.biomancy$getDeathSound());
        MobSoundUtil.putSound(tag, MobSoundType.HURT, livingEntityAccessor.biomancy$getHurtSound(livingEntity.m_9236_().m_269111_().m_269264_()));
        MobSoundUtil.putSound(tag, MobSoundType.AMBIENT, livingEntity instanceof Mob ? ((MobEntityAccessor)livingEntity).biomancy$getAmbientSound() : null);
        return tag;
    }

    public static void putSound(CompoundTag tag, MobSoundType soundType, @Nullable SoundEvent soundEvent) {
        if (soundEvent != null) {
            tag.m_128359_(soundType.m_7912_(), soundEvent.m_11660_().toString());
        } else {
            tag.m_128473_(soundType.m_7912_());
        }
    }

    @Nullable
    public static SoundEvent getSound(CompoundTag tag, MobSoundType soundType) {
        ResourceLocation soundId = ResourceLocation.m_135820_((String)tag.m_128461_(soundType.m_7912_()));
        if (soundId != null) {
            return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(soundId);
        }
        return null;
    }
}

