/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.util.fuel;

import com.github.elenterius.biomancy.api.nutrients.FluidNutrients;
import com.github.elenterius.biomancy.api.nutrients.FluidToFuelConversion;
import com.github.elenterius.biomancy.util.fuel.FuelHandler;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class FluidFuelConsumerHandler
implements IFluidHandler {
    private final FuelHandler fuelHandler;

    public FluidFuelConsumerHandler(FuelHandler fuelHandler) {
        this.fuelHandler = fuelHandler;
    }

    public boolean isFluidValid(int tank, FluidStack resource) {
        return FluidNutrients.isValidFuel(resource);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty()) {
            return 0;
        }
        FluidToFuelConversion fuelConversion = FluidNutrients.getFuelConversion(resource);
        if (fuelConversion == null) {
            return 0;
        }
        int valuePerUnit = fuelConversion.getFuelValuePerUnit(resource);
        if (valuePerUnit <= 0) {
            return 0;
        }
        int fuelAmount = resource.getAmount() * valuePerUnit;
        int fuelToFill = Math.min(this.fuelHandler.getMaxFuelAmount() - this.fuelHandler.getFuelAmount(), fuelAmount);
        int fluidFilled = fuelToFill / valuePerUnit;
        if (fluidFilled <= 0) {
            return 0;
        }
        if (action.simulate()) {
            return fluidFilled;
        }
        int fuelFilled = fluidFilled * valuePerUnit;
        this.fuelHandler.addFuelAmount(fuelFilled);
        return fluidFilled;
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        return FluidStack.EMPTY;
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        return FluidStack.EMPTY;
    }

    public int getTanks() {
        return 1;
    }

    public int getTankCapacity(int tank) {
        return this.fuelHandler.getMaxFuelAmount();
    }

    public FluidStack getFluidInTank(int tank) {
        return FluidStack.EMPTY;
    }
}

