/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.util.fuel;

import com.github.elenterius.biomancy.api.nutrients.Nutrients;
import com.github.elenterius.biomancy.inventory.Notify;
import com.github.elenterius.biomancy.util.fuel.IFuelHandler;
import java.util.function.IntUnaryOperator;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.INBTSerializable;

public class FuelHandler
implements IFuelHandler,
INBTSerializable<CompoundTag> {
    private final int maxFuel;
    private final IntUnaryOperator fuelCostModifierFunc;
    private final Predicate<ItemStack> fuelPredicate;
    private final ToIntFunction<ItemStack> fuelValueFunc;
    private final Notify changeNotifier;
    private int fuel;

    public FuelHandler(int maxFuel, IntUnaryOperator fuelCostModifierFunc, Predicate<ItemStack> fuelPredicate, ToIntFunction<ItemStack> fuelValueFunc, Notify changeNotifier) {
        this.maxFuel = maxFuel;
        this.fuelCostModifierFunc = fuelCostModifierFunc;
        this.fuelPredicate = fuelPredicate;
        this.fuelValueFunc = fuelValueFunc;
        this.changeNotifier = changeNotifier;
    }

    public static FuelHandler createNutrientFuelHandler(int maxFuel, Notify changeNotifier) {
        return new FuelHandler(maxFuel, IntUnaryOperator.identity(), Nutrients::isValidFuel, Nutrients::getFuelValue, changeNotifier);
    }

    @Override
    public int getFuelAmount() {
        return this.fuel;
    }

    @Override
    public void setFuelAmount(int amount) {
        boolean flag = amount != this.fuel;
        this.fuel = amount;
        if (flag) {
            this.setChanged();
        }
    }

    @Override
    public int getMaxFuelAmount() {
        return this.maxFuel;
    }

    @Override
    public void addFuelAmount(int amount) {
        this.setFuelAmount(Mth.m_14045_((int)(this.fuel + amount), (int)0, (int)this.maxFuel));
    }

    @Override
    public boolean isValidFuel(ItemStack stack) {
        return this.fuelPredicate.test(stack);
    }

    @Override
    public int getFuelCost(int craftingCostNutrients) {
        return this.fuelCostModifierFunc.applyAsInt(craftingCostNutrients);
    }

    @Override
    public int getFuelValue(ItemStack stack) {
        return this.fuelValueFunc.applyAsInt(stack);
    }

    public void setChanged() {
        this.changeNotifier.invoke();
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("Amount", this.fuel);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.fuel = tag.m_128451_("Amount");
    }
}

