/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.util.fuel;

import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemHandlerHelper;

public interface IFuelHandler {
    public int getFuelAmount();

    public int getMaxFuelAmount();

    public void setFuelAmount(int var1);

    public void addFuelAmount(int var1);

    public boolean isValidFuel(ItemStack var1);

    public int getFuelValue(ItemStack var1);

    default public int getFuelCost(int craftingCostNutrients) {
        return 1;
    }

    default public ItemStack addFuel(ItemStack stack) {
        if (stack.m_41619_()) {
            return stack;
        }
        if (!this.isValidFuel(stack)) {
            return stack;
        }
        int currFuelAmount = this.getFuelAmount();
        if (currFuelAmount >= this.getMaxFuelAmount()) {
            return stack;
        }
        int fuelValue = this.getFuelValue(stack);
        if (fuelValue <= 0) {
            return stack;
        }
        int neededCount = Mth.m_14143_((float)((float)Math.max(0, this.getMaxFuelAmount() - currFuelAmount) / (float)fuelValue));
        int consumeCount = Math.min(stack.m_41613_(), neededCount);
        if (consumeCount > 0) {
            int amount = Mth.m_14045_((int)(currFuelAmount + fuelValue * consumeCount), (int)0, (int)this.getMaxFuelAmount());
            this.setFuelAmount(amount);
            return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.m_41613_() - consumeCount));
        }
        return stack;
    }
}

