/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.world.spatial;

import java.util.Arrays;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.h2.mvstore.rtree.Spatial;

public final class SpatialQuery
implements Spatial {
    private final float[] minMax;

    private SpatialQuery(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        this.minMax = new float[]{minX, maxX, minY, maxY, minZ, maxZ};
    }

    public SpatialQuery(SpatialQuery other) {
        this.minMax = (float[])other.minMax.clone();
    }

    public float minX() {
        return this.minMax[0];
    }

    public float maxX() {
        return this.minMax[1];
    }

    public float minY() {
        return this.minMax[2];
    }

    public float maxY() {
        return this.minMax[3];
    }

    public float minZ() {
        return this.minMax[4];
    }

    public float maxZ() {
        return this.minMax[5];
    }

    public float min(int dim) {
        return this.minMax[dim + dim];
    }

    public void setMin(int dim, float v) {
        this.minMax[dim + dim] = v;
    }

    public float max(int dim) {
        return this.minMax[dim + dim + 1];
    }

    public void setMax(int dim, float x) {
        this.minMax[dim + dim + 1] = x;
    }

    public Spatial clone(long id) {
        return new SpatialQuery(this);
    }

    public long getId() {
        return 0L;
    }

    public boolean isNull() {
        return this.minMax.length == 0;
    }

    public int hashCode() {
        return Arrays.hashCode(this.minMax);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof SpatialQuery)) {
            return false;
        }
        SpatialQuery otherKey = (SpatialQuery)other;
        return this.equalsIgnoringId(otherKey);
    }

    public boolean equalsIgnoringId(Spatial other) {
        return Arrays.equals(this.minMax, ((SpatialQuery)other).minMax);
    }

    public static SpatialQuery of(BlockPos pos) {
        return new SpatialQuery(pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), (float)pos.m_123341_() + 1.0f, (float)pos.m_123342_() + 1.0f, (float)pos.m_123343_() + 1.0f);
    }

    public static SpatialQuery of(BlockPos posA, BlockPos posB) {
        int minX = Math.min(posA.m_123341_(), posB.m_123341_());
        int minY = Math.min(posA.m_123342_(), posB.m_123342_());
        int minZ = Math.min(posA.m_123343_(), posB.m_123343_());
        int maxX = Math.max(posA.m_123341_(), posB.m_123341_());
        int maxY = Math.max(posA.m_123342_(), posB.m_123342_());
        int maxZ = Math.max(posA.m_123343_(), posB.m_123343_());
        return new SpatialQuery(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public static SpatialQuery of(AABB aabb) {
        return new SpatialQuery((float)aabb.f_82288_, (float)aabb.f_82289_, (float)aabb.f_82290_, (float)aabb.f_82291_, (float)aabb.f_82292_, (float)aabb.f_82293_);
    }

    public static SpatialQuery of(Entity entity) {
        return SpatialQuery.of(entity.m_20191_());
    }

    public static SpatialQuery of(BoundingBox bb) {
        return new SpatialQuery(bb.m_162395_(), bb.m_162396_(), bb.m_162398_(), (float)bb.m_162399_() + 1.0f, (float)bb.m_162400_() + 1.0f, (float)bb.m_162401_() + 1.0f);
    }

    public static SpatialQuery of(Vec3 vecA, Vec3 vecB) {
        return new SpatialQuery((float)vecA.f_82479_, (float)vecA.f_82480_, (float)vecA.f_82481_, (float)vecB.f_82479_, (float)vecB.f_82480_, (float)vecB.f_82481_);
    }

    public static SpatialQuery unitCubeFromLowerCorner(Vec3 vec) {
        return new SpatialQuery((float)vec.f_82479_, (float)vec.f_82480_, (float)vec.f_82481_, (float)vec.f_82479_ + 1.0f, (float)vec.f_82480_ + 1.0f, (float)vec.f_82481_ + 1.0f);
    }

    public static SpatialQuery unitCubeFromMiddle(Vec3 vec) {
        return new SpatialQuery((float)vec.f_82479_ - 0.5f, (float)vec.f_82480_ - 0.5f, (float)vec.f_82481_ - 0.5f, (float)vec.f_82479_ + 0.5f, (float)vec.f_82480_ + 0.5f, (float)vec.f_82481_ + 0.5f);
    }
}

