/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.world.spatial;

import com.github.elenterius.biomancy.world.spatial.SpatialQuery;
import com.github.elenterius.biomancy.world.spatial.SpatialShapeStorage;
import com.github.elenterius.biomancy.world.spatial.geometry.Shape;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.rtree.MVRTreeMap;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(modid="biomancy", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class SpatialShapeManager {
    private SpatialShapeManager() {
    }

    @SubscribeEvent
    public static void onLevelUnload(LevelEvent.Unload event) {
        ServerLevel serverLevel;
        LevelAccessor levelAccessor;
        if (!event.getLevel().m_5776_() && (levelAccessor = event.getLevel()) instanceof ServerLevel && (serverLevel = (ServerLevel)levelAccessor).m_46472_() == Level.f_46428_) {
            SpatialShapeStorage storage = SpatialShapeStorage.getInstance(serverLevel);
            storage.close();
        }
    }

    private static String getLevelKey(ServerLevel level) {
        return level.m_46472_().m_135782_().toString();
    }

    public static Shape getOrCreateShape(ServerLevel level, BlockPos shapeId, Supplier<Shape> factory) {
        SpatialShapeStorage storage = SpatialShapeStorage.getInstance(level);
        return storage.getOrCreate(SpatialShapeManager.getLevelKey(level), shapeId.m_121878_(), factory);
    }

    public static void remove(ServerLevel level, BlockPos shapeId) {
        SpatialShapeStorage spatialStorage = SpatialShapeStorage.getInstance(level);
        spatialStorage.remove(SpatialShapeManager.getLevelKey(level), shapeId.m_121878_());
    }

    @Nullable
    public static Shape getClosestShape(ServerLevel level, BlockPos blockPos) {
        return SpatialShapeManager.getClosestShape(level, blockPos, shape -> true);
    }

    @Nullable
    public static Shape getClosestShape(ServerLevel level, BlockPos blockPos, Predicate<Shape> predicate) {
        SpatialQuery query = SpatialQuery.of(blockPos);
        SpatialShapeStorage spatialStorage = SpatialShapeStorage.getInstance(level);
        String levelKey = SpatialShapeManager.getLevelKey(level);
        float x = Mth.m_14179_((float)0.5f, (float)query.minX(), (float)query.maxX());
        float y = Mth.m_14179_((float)0.5f, (float)query.minY(), (float)query.maxY());
        float z = Mth.m_14179_((float)0.5f, (float)query.minZ(), (float)query.maxZ());
        double minDistSqr = Double.MAX_VALUE;
        Shape closestShape = null;
        MVRTreeMap.RTreeCursor<Long> intersectingKeys = spatialStorage.findIntersecting(levelKey, query);
        MVMap<Long, Shape> shapes = spatialStorage.getShapes(levelKey);
        while (intersectingKeys.hasNext()) {
            double distSqr;
            long id = intersectingKeys.next().getId();
            Shape shape = (Shape)shapes.get((Object)id);
            if (shape == null || !shape.contains(x, y, z) || !predicate.test(shape) || !((distSqr = shape.distanceToSqr(x, y, z)) < minDistSqr)) continue;
            closestShape = shape;
            minDistSqr = distSqr;
        }
        return closestShape;
    }

    @Nullable
    public static Shape getAnyShape(ServerLevel level, Entity entity, QueryStrategy strategy, Predicate<Shape> predicate) {
        return SpatialShapeManager.getAnyShape(level, strategy, SpatialQuery.of(entity), predicate);
    }

    @Nullable
    public static Shape getAnyShape(ServerLevel level, QueryStrategy strategy, SpatialQuery query, Predicate<Shape> predicate) {
        SpatialShapeStorage spatialStorage = SpatialShapeStorage.getInstance(level);
        String levelKey = SpatialShapeManager.getLevelKey(level);
        MVRTreeMap.RTreeCursor<Long> foundKeys = strategy.find(levelKey, query, spatialStorage);
        MVMap<Long, Shape> shapes = spatialStorage.getShapes(levelKey);
        while (foundKeys.hasNext()) {
            long id = foundKeys.next().getId();
            Shape shape = (Shape)shapes.get((Object)id);
            if (shape == null || !strategy.test(query, shape) || !predicate.test(shape)) continue;
            return shape;
        }
        return null;
    }

    public static interface QueryStrategy {
        public static final QueryStrategy INTERSECTION = new QueryStrategy(){

            @Override
            public MVRTreeMap.RTreeCursor<Long> find(String levelKey, SpatialQuery query, SpatialShapeStorage spatialStorage) {
                return spatialStorage.findIntersecting(levelKey, query);
            }

            @Override
            public boolean test(SpatialQuery query, Shape shape) {
                return shape.intersectsCuboid(query.minX(), query.minY(), query.minZ(), query.maxX(), query.maxY(), query.maxZ());
            }
        };

        public MVRTreeMap.RTreeCursor<Long> find(String var1, SpatialQuery var2, SpatialShapeStorage var3);

        public boolean test(SpatialQuery var1, Shape var2);
    }
}

