/*
 * Decompiled with CFR 0.152.
 */
package satisfy.herbalbrews.client.recipebook.group;

import com.google.common.collect.ImmutableList;
import de.cristelknight.doapi.client.recipebook.IRecipeBookGroup;
import java.util.List;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import satisfy.herbalbrews.recipe.TeaKettleRecipe;
import satisfy.herbalbrews.registry.ObjectRegistry;

@OnlyIn(value=Dist.CLIENT)
public enum TeaKettleRecipeBookGroup implements IRecipeBookGroup
{
    SEARCH(new ItemStack((ItemLike)Items.f_42522_)),
    FLASKS(new ItemStack((ItemLike)ObjectRegistry.FERAL_FLASK.get()));

    public static final List<IRecipeBookGroup> TEAKETTLE_GROUPS;
    private final List<ItemStack> icons;

    private TeaKettleRecipeBookGroup(ItemStack ... entries) {
        this.icons = ImmutableList.copyOf((Object[])entries);
    }

    public boolean fitRecipe(Recipe<?> recipe, RegistryAccess registryAccess) {
        if (recipe instanceof TeaKettleRecipe) {
            TeaKettleRecipe teaKettleRecipe = (TeaKettleRecipe)recipe;
            switch (this) {
                case SEARCH: {
                    return true;
                }
                case FLASKS: {
                    if (!teaKettleRecipe.m_7527_().stream().noneMatch(ingredient -> ingredient.test(Blocks.f_50126_.m_5456_().m_7968_()))) break;
                    return true;
                }
                default: {
                    return false;
                }
            }
        }
        return false;
    }

    public List<ItemStack> getIcons() {
        return this.icons;
    }

    static {
        TEAKETTLE_GROUPS = ImmutableList.of((Object)((Object)SEARCH), (Object)((Object)FLASKS));
    }
}

