/*
 * Decompiled with CFR 0.152.
 */
package satisfy.herbalbrews.registry;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import de.cristelknight.doapi.Util;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.food.Foods;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import satisfy.herbalbrews.blocks.BonemealableFlower;
import satisfy.herbalbrews.blocks.CauldronBlock;
import satisfy.herbalbrews.blocks.CoffeeCropBlock;
import satisfy.herbalbrews.blocks.JugBlock;
import satisfy.herbalbrews.blocks.RooibosCropBlock;
import satisfy.herbalbrews.blocks.StoveBlock;
import satisfy.herbalbrews.blocks.TeaCropBlock;
import satisfy.herbalbrews.blocks.TeaCupBlock;
import satisfy.herbalbrews.blocks.TeaKettleBlock;
import satisfy.herbalbrews.blocks.TeaLeafBlock;
import satisfy.herbalbrews.blocks.YerbaMateCropBlock;
import satisfy.herbalbrews.items.DrinkBlockItem;
import satisfy.herbalbrews.items.DrinkItem;
import satisfy.herbalbrews.items.HatItem;
import satisfy.herbalbrews.items.HerbalbrewsStandardItem;
import satisfy.herbalbrews.items.JugItem;
import satisfy.herbalbrews.registry.EffectRegistry;
import satisfy.herbalbrews.util.FoodComponent;
import satisfy.herbalbrews.util.HerbalBrewsIdentifier;

public class ObjectRegistry {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((String)"herbalbrews", (ResourceKey)Registries.f_256913_);
    public static final Registrar<Item> ITEM_REGISTRAR = ITEMS.getRegistrar();
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((String)"herbalbrews", (ResourceKey)Registries.f_256747_);
    public static final Registrar<Block> BLOCK_REGISTRAR = BLOCKS.getRegistrar();
    public static final RegistrySupplier<Block> STOVE = ObjectRegistry.registerWithItem("stove", () -> new StoveBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50076_).m_60953_(state -> (Boolean)state.m_61143_((Property)StoveBlock.LIT) != false ? 13 : 0).m_60977_()));
    public static final RegistrySupplier<Block> TEA_LEAF_CRATE = ObjectRegistry.registerWithItem("tea_leaf_crate", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50108_)));
    public static final RegistrySupplier<Block> GREEN_TEA_LEAF_BLOCK = ObjectRegistry.registerWithItem("green_tea_leaf_block", () -> new TeaLeafBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50054_)));
    public static final RegistrySupplier<Block> DRIED_GREEN_TEA_LEAF_BLOCK = ObjectRegistry.registerWithItem("dried_green_tea_leaf_block", () -> new TeaLeafBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50054_)));
    public static final RegistrySupplier<Block> DRIED_OUT_GREEN_TEA_LEAF_BLOCK = ObjectRegistry.registerWithItem("dried_out_green_tea_leaf_block", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50054_)));
    public static final RegistrySupplier<Block> BLACK_TEA_LEAF_BLOCK = ObjectRegistry.registerWithItem("black_tea_leaf_block", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50054_)));
    public static final RegistrySupplier<Block> MIXED_TEA_LEAF_BLOCK = ObjectRegistry.registerWithItem("mixed_tea_leaf_block", () -> new TeaLeafBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50054_)));
    public static final RegistrySupplier<Block> OOLONG_TEA_LEAF_BLOCK = ObjectRegistry.registerWithItem("oolong_tea_leaf_block", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50054_)));
    public static final RegistrySupplier<Block> WILD_COFFEE_PLANT = ObjectRegistry.registerWithItem("wild_coffee_plant", () -> new FlowerBlock(MobEffects.f_19601_, 1, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50111_)));
    public static final RegistrySupplier<Block> COFFEE_PLANT = ObjectRegistry.registerWithoutItem("coffee_plant", () -> new CoffeeCropBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50685_)));
    public static final RegistrySupplier<Block> WILD_ROOIBOS_PLANT = ObjectRegistry.registerWithItem("wild_rooibos_plant", () -> new FlowerBlock(MobEffects.f_19601_, 1, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50111_)));
    public static final RegistrySupplier<Block> ROOIBOS_PLANT = ObjectRegistry.registerWithoutItem("rooibos_plant", () -> new RooibosCropBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50685_)));
    public static final RegistrySupplier<Block> WILD_YERBA_MATE_PLANT = ObjectRegistry.registerWithItem("wild_yerba_mate_plant", () -> new FlowerBlock(MobEffects.f_19601_, 1, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50111_)));
    public static final RegistrySupplier<Block> YERBA_MATE_PLANT = ObjectRegistry.registerWithoutItem("yerba_mate_plant", () -> new YerbaMateCropBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50685_)));
    public static final RegistrySupplier<Block> TEA_PLANT = ObjectRegistry.registerWithoutItem("tea_plant", () -> new TeaCropBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50685_)));
    public static final RegistrySupplier<Block> HIBISCUS = ObjectRegistry.registerWithItem("hibiscus", () -> new BonemealableFlower(MobEffects.f_19601_, 1, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50111_)));
    public static final RegistrySupplier<Block> LAVENDER = ObjectRegistry.registerWithItem("lavender", () -> new BonemealableFlower(MobEffects.f_19601_, 1, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50111_)));
    public static final RegistrySupplier<Block> JUG = ObjectRegistry.registerWithoutItem("jug", () -> new JugBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50058_)));
    public static final RegistrySupplier<Item> JUG_ITEM = ObjectRegistry.registerItem("jug", () -> new JugItem((Block)JUG.get(), ObjectRegistry.getSettings()));
    public static final RegistrySupplier<Block> COPPER_TEA_KETTLE = ObjectRegistry.registerWithItem("copper_tea_kettle", () -> new TeaKettleBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_)));
    public static final RegistrySupplier<Block> TEA_KETTLE = ObjectRegistry.registerWithItem("tea_kettle", () -> new TeaKettleBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_)));
    public static final RegistrySupplier<Block> CAULDRON = ObjectRegistry.registerWithItem("cauldron", () -> new CauldronBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_).m_60953_(blockState -> 11)));
    public static final RegistrySupplier<Item> ARMOR_FLASK = ObjectRegistry.registerItem("armor_flask", () -> new DrinkItem(ObjectRegistry.getFoodItemSettings(0.8f, (MobEffect)EffectRegistry.ARMOR.get(), 6000)));
    public static final RegistrySupplier<Item> ARMOR_FLASK_BIG = ObjectRegistry.registerItem("armor_flask_big", () -> new DrinkItem(ObjectRegistry.getFoodItemSettings(0.8f, (MobEffect)EffectRegistry.ARMOR.get(), 12000)));
    public static final RegistrySupplier<Item> DAMAGE_FLASK = ObjectRegistry.registerItem("damage_flask", () -> new DrinkItem(ObjectRegistry.getFoodItemSettings(0.8f, (MobEffect)EffectRegistry.DAMAGE.get(), 6000)));
    public static final RegistrySupplier<Item> DAMAGE_FLASK_BIG = ObjectRegistry.registerItem("damage_flask_big", () -> new DrinkItem(ObjectRegistry.getFoodItemSettings(0.8f, (MobEffect)EffectRegistry.DAMAGE.get(), 12000)));
    public static final RegistrySupplier<Item> FERAL_FLASK = ObjectRegistry.registerItem("feral_flask", () -> new DrinkItem(ObjectRegistry.getFoodItemSettings(0.8f, (MobEffect)EffectRegistry.FERAL.get(), 6000)));
    public static final RegistrySupplier<Item> FERAL_FLASK_BIG = ObjectRegistry.registerItem("feral_flask_big", () -> new DrinkItem(ObjectRegistry.getFoodItemSettings(0.8f, (MobEffect)EffectRegistry.FERAL.get(), 12000)));
    public static final RegistrySupplier<Item> TEA_BLOSSOM = ObjectRegistry.registerItem("tea_blossom", () -> new BlockItem((Block)TEA_PLANT.get(), ObjectRegistry.getSettings().m_41489_(new FoodProperties.Builder().m_38760_(1).m_38758_(0.1f).m_38766_().m_38765_().m_38767_())));
    public static final RegistrySupplier<Item> GREEN_TEA_LEAF = ObjectRegistry.registerItem("green_tea_leaf", () -> new Item(ObjectRegistry.getSettings()));
    public static final RegistrySupplier<Item> YERBA_MATE_LEAF = ObjectRegistry.registerItem("yerba_mate_leaf", () -> new BlockItem((Block)YERBA_MATE_PLANT.get(), ObjectRegistry.getSettings().m_41489_(new FoodProperties.Builder().m_38760_(1).m_38758_(0.1f).m_38766_().m_38765_().m_38767_())));
    public static final RegistrySupplier<Item> ROOIBOS_LEAF = ObjectRegistry.registerItem("rooibos_leaf", () -> new BlockItem((Block)ROOIBOS_PLANT.get(), ObjectRegistry.getSettings().m_41489_(new FoodProperties.Builder().m_38760_(1).m_38758_(0.1f).m_38766_().m_38765_().m_38767_())));
    public static final RegistrySupplier<Item> LAVENDER_BLOSSOM = ObjectRegistry.registerItem("lavender_blossom", () -> new Item(ObjectRegistry.getSettings()));
    public static final RegistrySupplier<Item> DRIED_GREEN_TEA = ObjectRegistry.registerItem("dried_green_tea", () -> new Item(ObjectRegistry.getSettings().m_41489_(new FoodProperties.Builder().m_38760_(1).m_38758_(0.1f).m_38766_().m_38765_().m_38767_())));
    public static final RegistrySupplier<Item> DRIED_BLACK_TEA = ObjectRegistry.registerItem("dried_black_tea", () -> new Item(ObjectRegistry.getSettings().m_41489_(new FoodProperties.Builder().m_38760_(1).m_38758_(0.1f).m_38766_().m_38765_().m_38767_())));
    public static final RegistrySupplier<Item> DRIED_OOLONG_TEA = ObjectRegistry.registerItem("dried_oolong_tea", () -> new Item(ObjectRegistry.getSettings().m_41489_(new FoodProperties.Builder().m_38760_(1).m_38758_(0.1f).m_38766_().m_38765_().m_38767_())));
    public static final RegistrySupplier<Item> COFFEE_BEANS = ObjectRegistry.registerItem("coffee_beans", () -> new BlockItem((Block)COFFEE_PLANT.get(), ObjectRegistry.getSettings().m_41489_(new FoodProperties.Builder().m_38760_(1).m_38758_(0.1f).m_38766_().m_38765_().m_38767_())));
    public static final RegistrySupplier<Item> GREEN_TEA = ObjectRegistry.registerItem("green_tea", () -> new DrinkItem(ObjectRegistry.getFoodItemSettings(0.7f, (MobEffect)EffectRegistry.BALANCED.get(), 1800)));
    public static final RegistrySupplier<Item> BLACK_TEA = ObjectRegistry.registerItem("black_tea", () -> new DrinkItem(ObjectRegistry.getFoodItemSettings(0.7f, (MobEffect)EffectRegistry.REVITALIZING.get(), 1800)));
    public static final RegistrySupplier<Item> LAVENDER_TEA = ObjectRegistry.registerItem("lavender_tea", () -> new DrinkItem(ObjectRegistry.getFoodItemSettings(0.7f, (MobEffect)EffectRegistry.FORTUNE.get(), 1800)));
    public static final RegistrySupplier<Item> YERBA_MATE_TEA = ObjectRegistry.registerItem("yerba_mate_tea", () -> new DrinkItem(ObjectRegistry.getFoodItemSettings(0.7f, (MobEffect)EffectRegistry.POISONOUSBREATH.get(), 1800)));
    public static final RegistrySupplier<Item> OOLONG_TEA = ObjectRegistry.registerItem("oolong_tea", () -> new DrinkItem(ObjectRegistry.getFoodItemSettings(0.7f, (MobEffect)EffectRegistry.RENEWAL.get(), 1800)));
    public static final RegistrySupplier<Item> ROOIBOS_TEA = ObjectRegistry.registerItem("rooibos_tea", () -> new DrinkItem(ObjectRegistry.getFoodItemSettings(0.7f, (MobEffect)EffectRegistry.EXCAVATION.get(), 1800)));
    public static final RegistrySupplier<Block> HIBISCUS_TEA_BLOCK = ObjectRegistry.registerTea("hibiscus_tea_block", () -> new TeaCupBlock(ObjectRegistry.getTeaSettings()), EffectRegistry.FERAL);
    public static final RegistrySupplier<Item> HIBISCUS_TEA = ObjectRegistry.registerItem("hibiscus_tea", () -> new DrinkBlockItem((Block)HIBISCUS_TEA_BLOCK.get(), ObjectRegistry.getSettings().m_41489_(new FoodProperties.Builder().m_38760_(Foods.f_38808_.m_38744_()).m_38758_(Foods.f_38808_.m_38745_()).m_38765_().m_38767_()), new MobEffectInstance((MobEffect)EffectRegistry.FERAL.get(), 1800, 0)));
    public static final RegistrySupplier<Block> MILK_COFFEE_BLOCK = ObjectRegistry.registerTea("milk_coffee_block", () -> new TeaCupBlock(ObjectRegistry.getTeaSettings()), EffectRegistry.TOUGH);
    public static final RegistrySupplier<Item> MILK_COFFEE = ObjectRegistry.registerItem("milk_coffee", () -> new DrinkBlockItem((Block)MILK_COFFEE_BLOCK.get(), ObjectRegistry.getSettings().m_41489_(new FoodProperties.Builder().m_38760_(Foods.f_38808_.m_38744_()).m_38758_(Foods.f_38808_.m_38745_()).m_38765_().m_38767_()), new MobEffectInstance((MobEffect)EffectRegistry.TOUGH.get(), 1800, 0)));
    public static final RegistrySupplier<Item> COFFEE = ObjectRegistry.registerItem("coffee", () -> new DrinkItem(ObjectRegistry.getFoodItemSettings(0.7f, (MobEffect)EffectRegistry.TOUGH.get(), 1800)));
    public static final RegistrySupplier<Item> WITCH_HAT = ObjectRegistry.registerItem("witch_hat", () -> new HatItem((ArmorMaterial)ArmorMaterials.LEATHER, ArmorItem.Type.HELMET, new Item.Properties(), new HerbalBrewsIdentifier("textures/entity/witch_hat.png")));
    public static final RegistrySupplier<Item> TOP_HAT = ObjectRegistry.registerItem("top_hat", () -> new HatItem((ArmorMaterial)ArmorMaterials.LEATHER, ArmorItem.Type.HELMET, new Item.Properties(), new HerbalBrewsIdentifier("textures/entity/top_hat.png")));
    public static final RegistrySupplier<Item> HERBALBREWS_STANDARD = ObjectRegistry.registerItem("herbalbrews_standard", () -> new HerbalbrewsStandardItem(new Item.Properties().m_41487_(16).m_41497_(Rarity.UNCOMMON)));
    public static final RegistrySupplier<Block> POTTED_LAVENDER = ObjectRegistry.registerWithoutItem("potted_lavender", () -> new FlowerPotBlock((Block)LAVENDER.get(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50276_)));
    public static final RegistrySupplier<Block> POTTED_HIBISCUS = ObjectRegistry.registerWithoutItem("potted_hibiscus", () -> new FlowerPotBlock((Block)HIBISCUS.get(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50276_)));
    public static final RegistrySupplier<Block> POTTED_WILD_ROOIBOS = ObjectRegistry.registerWithoutItem("potted_wild_rooibos", () -> new FlowerPotBlock((Block)WILD_ROOIBOS_PLANT.get(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50276_)));
    public static final RegistrySupplier<Block> POTTED_WILD_COFFEE = ObjectRegistry.registerWithoutItem("potted_wild_coffee", () -> new FlowerPotBlock((Block)WILD_COFFEE_PLANT.get(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50276_)));
    public static final RegistrySupplier<Block> POTTED_WILD_YERBA_MATE = ObjectRegistry.registerWithoutItem("potted_wild_yerba_mate", () -> new FlowerPotBlock((Block)WILD_YERBA_MATE_PLANT.get(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50276_)));

    public static void init() {
        ITEMS.register();
        BLOCKS.register();
    }

    private static Item.Properties getSettings(Consumer<Item.Properties> consumer) {
        Item.Properties settings = new Item.Properties();
        consumer.accept(settings);
        return settings;
    }

    private static Item.Properties getSettingsWithoutTab(Consumer<Item.Properties> consumer) {
        Item.Properties settings = new Item.Properties();
        consumer.accept(settings);
        return settings;
    }

    static Item.Properties getSettings() {
        return ObjectRegistry.getSettings(settings -> {});
    }

    private static Item.Properties getWineItemSettings(MobEffect effect) {
        return ObjectRegistry.getSettings().m_41489_(ObjectRegistry.wineFoodComponent(effect, 900));
    }

    private static Item.Properties getWineItemSettings(MobEffect effect, int duration) {
        return ObjectRegistry.getSettings().m_41489_(ObjectRegistry.wineFoodComponent(effect, duration));
    }

    private static FoodProperties wineFoodComponent(MobEffect effect, int duration) {
        ArrayList effects = Lists.newArrayList();
        if (effect != null) {
            effects.add(Pair.of((Object)new MobEffectInstance(effect, duration), (Object)Float.valueOf(1.0f)));
        }
        return new FoodComponent(effects);
    }

    private static Item.Properties getFoodItemSettings(float saturationMod, MobEffect effect, int duration) {
        return ObjectRegistry.getFoodItemSettings(saturationMod, effect, duration, true);
    }

    private static Item.Properties getFoodItemSettings(float saturationMod, MobEffect effect, int duration, boolean fast) {
        return ObjectRegistry.getSettings().m_41489_(ObjectRegistry.createFood(saturationMod, effect, duration, fast));
    }

    private static FoodProperties createFood(float saturationMod, MobEffect effect, int duration, boolean fast) {
        FoodProperties.Builder food = new FoodProperties.Builder().m_38760_(4).m_38758_(saturationMod);
        food.m_38765_();
        if (fast) {
            food.m_38766_();
        }
        if (effect != null) {
            food.m_38762_(new MobEffectInstance(effect, duration), 1.0f);
        }
        return food.m_38767_();
    }

    private static Item.Properties getSettingsWithoutTab() {
        return ObjectRegistry.getSettingsWithoutTab(settings -> {});
    }

    public static <T extends Block> RegistrySupplier<T> registerWithItem(String name, Supplier<T> block) {
        return Util.registerWithItem(BLOCKS, BLOCK_REGISTRAR, ITEMS, ITEM_REGISTRAR, (ResourceLocation)new HerbalBrewsIdentifier(name), block);
    }

    public static <T extends Block> RegistrySupplier<T> registerWithoutItem(String path, Supplier<T> block) {
        return Util.registerWithoutItem(BLOCKS, BLOCK_REGISTRAR, (ResourceLocation)new HerbalBrewsIdentifier(path), block);
    }

    public static <T extends Item> RegistrySupplier<T> registerItem(String path, Supplier<T> itemSupplier) {
        return Util.registerItem(ITEMS, ITEM_REGISTRAR, (ResourceLocation)new HerbalBrewsIdentifier(path), itemSupplier);
    }

    private static ButtonBlock createWoodenButtonBlock(BlockSetType blockSetType, FeatureFlag ... requiredFeatures) {
        BlockBehaviour.Properties settings = BlockBehaviour.Properties.m_284310_().m_60910_().m_60978_(0.5f).m_278166_(PushReaction.DESTROY);
        if (requiredFeatures.length > 0) {
            settings = settings.m_246843_(requiredFeatures);
        }
        return new ButtonBlock(settings, blockSetType, 30, true);
    }

    private static FoodProperties teaFoodComponent(MobEffect effect) {
        FoodProperties.Builder component = new FoodProperties.Builder().m_38760_(2).m_38758_(2.0f);
        if (effect != null) {
            component.m_38762_(new MobEffectInstance(effect, 36000), 1.0f);
        }
        return component.m_38767_();
    }

    private static BlockBehaviour.Properties getTeaSettings() {
        return BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50058_).m_60955_().m_60966_();
    }

    private static <T extends Block> RegistrySupplier<T> registerTea(String name, Supplier<T> block, RegistrySupplier<MobEffect> effect) {
        RegistrySupplier toReturn = ObjectRegistry.registerWithoutItem(name, block);
        ObjectRegistry.registerItem(name, () -> new DrinkBlockItem((Block)toReturn.get(), ObjectRegistry.getSettings(settings -> settings.m_41489_(ObjectRegistry.teaFoodComponent((MobEffect)effect.get()))), new MobEffectInstance((MobEffect)effect.get(), 1800, 1)));
        return toReturn;
    }
}

