/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.block_entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.world.inventory.InventoryMenu;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import vazkii.botania.api.state.BotaniaStateProperties;
import vazkii.botania.api.state.enums.AlfheimPortalState;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.common.block.block_entity.AlfheimPortalBlockEntity;
import vazkii.botania.common.helper.VecHelper;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class AlfheimPortalBlockEntityRenderer
implements BlockEntityRenderer<AlfheimPortalBlockEntity> {
    private final TextureAtlasSprite portalSprite = Objects.requireNonNull((TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(ResourceLocationHelper.prefix("block/alfheim_portal_swirl")));

    public AlfheimPortalBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(@NotNull AlfheimPortalBlockEntity portal, float f, PoseStack ms, MultiBufferSource buffers, int light, int overlay) {
        AlfheimPortalState state = (AlfheimPortalState)((Object)portal.m_58900_().m_61143_(BotaniaStateProperties.ALFPORTAL_STATE));
        if (state == AlfheimPortalState.OFF) {
            return;
        }
        float alpha = (float)Math.min(1.0, (Math.sin((double)((float)ClientTickHandler.ticksInGame + f) / 8.0) + 1.0) / 7.0 + 0.6) * ((float)Math.min(60, portal.ticksOpen) / 60.0f) * 0.5f;
        ms.m_85836_();
        if (state == AlfheimPortalState.ON_X) {
            ms.m_85837_(0.75, 1.0, 2.0);
            ms.m_252781_(VecHelper.rotateY(90.0f));
        } else {
            ms.m_85837_(-1.0, 1.0, 0.75);
        }
        this.renderIcon(ms, buffers, this.portalSprite, 0, 0, 3, 3, alpha, overlay);
        ms.m_85849_();
        ms.m_85836_();
        if (state == AlfheimPortalState.ON_X) {
            ms.m_85837_(0.25, 1.0, -1.0);
            ms.m_252781_(VecHelper.rotateY(90.0f));
        } else {
            ms.m_85837_(2.0, 1.0, 0.25);
        }
        ms.m_252781_(VecHelper.rotateY(180.0f));
        this.renderIcon(ms, buffers, this.portalSprite, 0, 0, 3, 3, alpha, overlay);
        ms.m_85849_();
    }

    public void renderIcon(PoseStack ms, MultiBufferSource buffers, TextureAtlasSprite icon, int x, int y, int width, int height, float alpha, int overlay) {
        VertexConsumer buffer = buffers.m_6299_(Sheets.m_110791_());
        Matrix4f model = ms.m_85850_().m_252922_();
        Matrix3f normal = ms.m_85850_().m_252943_();
        buffer.m_252986_(model, (float)x, (float)(y + height), 0.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(icon.m_118409_(), icon.m_118412_()).m_86008_(overlay).m_85969_(0xF000F0).m_252939_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(model, (float)(x + width), (float)(y + height), 0.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(icon.m_118410_(), icon.m_118412_()).m_86008_(overlay).m_85969_(0xF000F0).m_252939_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(model, (float)(x + width), (float)y, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(icon.m_118410_(), icon.m_118411_()).m_86008_(overlay).m_85969_(0xF000F0).m_252939_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(model, (float)x, (float)y, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(icon.m_118409_(), icon.m_118411_()).m_86008_(overlay).m_85969_(0xF000F0).m_252939_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
    }
}

