/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.item.BlockProvider;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.item.rod.ShiftingCrustRodItem;
import vazkii.botania.xplat.BotaniaConfig;

public class EnderHandItem
extends Item {
    private static final int COST_PROVIDE = 5;
    private static final int COST_SELF = 250;
    private static final int COST_OTHER = 5000;

    public EnderHandItem(Item.Properties props) {
        super(props);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (ManaItemHandler.instance().requestManaExact(stack, player, 250, false)) {
            if (!player.m_9236_().f_46443_) {
                player.m_5893_((MenuProvider)new SimpleMenuProvider((windowId, playerInv, p) -> ChestMenu.m_39237_((int)windowId, (Inventory)playerInv, (Container)p.m_36327_()), stack.m_41786_()));
                ManaItemHandler.instance().requestManaExact(stack, player, 250, true);
            }
            player.m_5496_(SoundEvents.f_11889_, 1.0f, 1.0f);
            return InteractionResultHolder.m_19092_((Object)stack, (boolean)world.m_5776_());
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity entity, InteractionHand hand) {
        if (entity.m_6084_() && BotaniaConfig.common().enderPickpocketEnabled() && entity instanceof Player) {
            Player other = (Player)entity;
            if (ManaItemHandler.instance().requestManaExact(stack, player, 5000, false)) {
                if (!player.m_9236_().f_46443_) {
                    player.m_5893_((MenuProvider)new SimpleMenuProvider((windowId, playerInv, p) -> ChestMenu.m_39237_((int)windowId, (Inventory)playerInv, (Container)other.m_36327_()), stack.m_41786_()));
                    ManaItemHandler.instance().requestManaExact(stack, player, 5000, true);
                }
                player.m_5496_(SoundEvents.f_11889_, 1.0f, 1.0f);
                return InteractionResult.m_19078_((boolean)player.m_9236_().m_5776_());
            }
        }
        return InteractionResult.PASS;
    }

    public static class BlockProviderImpl
    implements BlockProvider {
        private final ItemStack stack;

        public BlockProviderImpl(ItemStack stack) {
            this.stack = stack;
        }

        @Override
        public boolean provideBlock(Player player, ItemStack requestor, Block block, boolean doit) {
            boolean mana;
            if (!requestor.m_41619_() && requestor.m_150930_(this.stack.m_41720_())) {
                return false;
            }
            ItemStack istack = ShiftingCrustRodItem.removeFromInventory(player, (Container)player.m_36327_(), this.stack, block.m_5456_(), false);
            if (!istack.m_41619_() && (mana = ManaItemHandler.instance().requestManaExact(this.stack, player, 5, false))) {
                if (doit) {
                    ManaItemHandler.instance().requestManaExact(this.stack, player, 5, true);
                    ShiftingCrustRodItem.removeFromInventory(player, (Container)player.m_36327_(), this.stack, block.m_5456_(), true);
                }
                return true;
            }
            return false;
        }

        @Override
        public int getBlockCount(Player player, ItemStack requestor, Block block) {
            if (!requestor.m_41619_() && requestor.m_150930_(this.stack.m_41720_())) {
                return 0;
            }
            return ShiftingCrustRodItem.getInventoryItemCount(player, (Container)player.m_36327_(), this.stack, block.m_5456_());
        }
    }
}

