/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.bauble;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.render.AccessoryRenderRegistry;
import vazkii.botania.client.render.AccessoryRenderer;
import vazkii.botania.common.block.flower.functional.HeiseiDreamBlockEntity;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.handler.EquipmentHandler;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.equipment.bauble.BaubleItem;
import vazkii.botania.common.proxy.Proxy;
import vazkii.botania.mixin.CreeperAccessor;
import vazkii.botania.mixin.EntityAccessor;
import vazkii.botania.network.EffectType;
import vazkii.botania.network.clientbound.BotaniaEffectPacket;
import vazkii.botania.xplat.XplatAbstractions;

public class CharmOfTheDivaItem
extends BaubleItem {
    public static final int MANA_COST = 250;
    public static final int CHARM_RANGE = 20;
    private static final String TAG_MOBS_TO_CHARM = "mobsToCharm";

    public CharmOfTheDivaItem(Item.Properties props) {
        super(props);
        Proxy.INSTANCE.runOnClient(() -> () -> AccessoryRenderRegistry.register(this, new Renderer()));
    }

    @Override
    public void onWornTick(ItemStack stack, LivingEntity entity) {
        if (entity.m_9236_().m_5776_()) {
            return;
        }
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128425_(TAG_MOBS_TO_CHARM, 11)) {
            CharmOfTheDivaItem.charmMobs(stack, (Player)entity, tag.m_128465_(TAG_MOBS_TO_CHARM));
            stack.m_41749_(TAG_MOBS_TO_CHARM);
        }
    }

    @Override
    public void onEquipped(ItemStack stack, LivingEntity entity) {
        if (!entity.m_9236_().m_5776_()) {
            stack.m_41749_(TAG_MOBS_TO_CHARM);
        }
    }

    @Override
    public void onUnequipped(ItemStack stack, LivingEntity entity) {
        if (!entity.m_9236_().m_5776_()) {
            stack.m_41749_(TAG_MOBS_TO_CHARM);
        }
    }

    private static Predicate<Mob> getCharmTargetPredicate(Player player, Mob mobToCharm) {
        return mob -> {
            TamableAnimal targetTamable;
            LivingEntity patt3177$temp;
            NeutralMob neutralMob;
            TamableAnimal tamable;
            return mob != mobToCharm && mob.m_6084_() && mob.m_142066_() && !mob.m_20365_((Entity)mobToCharm) && (!(mob instanceof TamableAnimal) || !(tamable = (TamableAnimal)mob).m_21830_((LivingEntity)player)) && (mob instanceof Enemy || mob instanceof NeutralMob && ((neutralMob = (NeutralMob)mob).m_21674_((LivingEntity)player) || (patt3177$temp = mob.m_5448_()) instanceof TamableAnimal && (targetTamable = (TamableAnimal)patt3177$temp).m_21830_((LivingEntity)player)));
        };
    }

    private static void charmMobs(ItemStack amulet, Player player, int[] mobsToCharmIds) {
        for (int mobId : mobsToCharmIds) {
            List potentialTargets;
            TamableAnimal tamable;
            Mob target;
            if (!ManaItemHandler.instance().requestManaExact(amulet, player, 250, false)) {
                return;
            }
            Entity mobEntity = player.m_9236_().m_6815_(mobId);
            if (!(mobEntity instanceof Mob) || !(target = (Mob)mobEntity).m_6084_() || !(mobEntity instanceof Enemy) && !(mobEntity instanceof NeutralMob) || mobEntity instanceof TamableAnimal && (tamable = (TamableAnimal)mobEntity).m_21830_((LivingEntity)player) || !player.m_20182_().m_82509_((Position)target.m_20182_(), 20.0) || (potentialTargets = player.m_9236_().m_6443_(Mob.class, AABB.m_165882_((Vec3)target.m_20182_(), (double)40.0, (double)40.0, (double)40.0), CharmOfTheDivaItem.getCharmTargetPredicate(player, target))).isEmpty() || !HeiseiDreamBlockEntity.brainwashEntity(target, potentialTargets)) continue;
            target.m_5634_(target.m_21233_());
            ((EntityAccessor)target).callUnsetRemoved();
            if (target instanceof Creeper) {
                ((CreeperAccessor)target).setCurrentFuseTime(2);
            }
            ManaItemHandler.instance().requestManaExact(amulet, player, 250, true);
            player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), BotaniaSounds.divaCharm, SoundSource.PLAYERS, 1.0f, 1.0f);
            XplatAbstractions.INSTANCE.sendToTracking((Entity)target, new BotaniaEffectPacket(EffectType.DIVA_EFFECT, target.m_20185_(), target.m_20186_(), target.m_20189_(), target.m_19879_()));
        }
    }

    public static void onEntityDamaged(Player player, Entity entity) {
        if (entity instanceof Mob) {
            ItemStack amulet;
            Mob target = (Mob)entity;
            if (!entity.m_9236_().f_46443_ && Math.random() < (double)0.6f && !(amulet = EquipmentHandler.findOrEmpty(BotaniaItems.divaCharm, (LivingEntity)player)).m_41619_()) {
                int[] entityIds;
                CompoundTag tag = amulet.m_41784_();
                if (tag.m_128425_(TAG_MOBS_TO_CHARM, 11)) {
                    int[] oldIds = tag.m_128465_(TAG_MOBS_TO_CHARM);
                    entityIds = Arrays.copyOf(oldIds, oldIds.length + 1);
                    entityIds[entityIds.length - 1] = entity.m_19879_();
                } else {
                    entityIds = new int[]{entity.m_19879_()};
                }
                tag.m_128385_(TAG_MOBS_TO_CHARM, entityIds);
            }
        }
    }

    public static class Renderer
    implements AccessoryRenderer {
        @Override
        public void doRender(HumanoidModel<?> bipedModel, ItemStack stack, LivingEntity living, PoseStack ms, MultiBufferSource buffers, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            bipedModel.f_102808_.m_104299_(ms);
            ms.m_85837_(0.15, -0.42, -0.35);
            ms.m_85841_(0.4f, -0.4f, -0.4f);
            Minecraft.m_91087_().m_91291_().m_269128_(stack, ItemDisplayContext.NONE, light, OverlayTexture.f_118083_, ms, buffers, living.m_9236_(), living.m_19879_());
        }
    }
}

