/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.test.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.gametest.framework.GameTestAssertException;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.ForceRelayBlock;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.mana.ManaSpreaderBlockEntity;
import vazkii.botania.common.block.flower.generating.EntropinnyumBlockEntity;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.test.TestingUtil;

public class EntropinnyumUnethicalTntDetectionTest {
    private static final String TEMPLATE_SLIME_DUPER_FORCE_LENS = "botania:block/entropinnyum_unethical_slime_duper_force_lens";
    private static final String TEMPLATE_SLIME_DUPER_FORCE_RELAY = "botania:block/entropinnyum_unethical_slime_duper_force_relay";
    private static final String TEMPLATE_ENTITYLESS_DUPER = "botania:block/entropinnyum_unethical_entityless_duper";
    private static final String TEMPLATE_LEGIT_TNT = "botania:block/entropinnyum_ethical_tnt_block";
    private static final BlockPos POSITION_ENTROPINNYUM = new BlockPos(9, 1, 9);
    private static final BlockPos POSITION_FORCE_LENS_DETECTOR_RAIL = new BlockPos(7, 16, 10);
    private static final BlockPos POSITION_FORCE_LENS_PUSHED_SLIME_BLOCK = new BlockPos(6, 16, 10);
    private static final BlockPos POSITION_FORCE_LENS_MANA_SPREADER = new BlockPos(5, 16, 10);
    private static final BlockPos POSITION_FORCE_LENS_BUTTON = new BlockPos(5, 16, 8);
    private static final BlockPos POSITION_FORCE_RELAY_DETECTOR_RAIL = new BlockPos(4, 4, 10);
    private static final BlockPos POSITION_FORCE_RELAY_PUSHED_SLIME_BLOCK = new BlockPos(3, 4, 10);
    private static final BlockPos POSITION_FORCE_RELAY = new BlockPos(4, 3, 6);
    private static final BlockPos POSITION_FORCE_RELAY_BUTTON = new BlockPos(2, 4, 5);
    private static final BlockPos POSITION_ENTITYLESS_DUPER_BUTTON = new BlockPos(3, 13, 10);
    private static final BlockPos POSITION_ETHICAL_TNT_BLOCK_BUTTON = new BlockPos(9, 4, 9);

    private static Runnable checkEntropinnyumForUnethicalManaAmount(GameTestHelper helper) {
        return () -> {
            BlockEntity be = helper.m_177347_(POSITION_ENTROPINNYUM);
            if (!(be instanceof EntropinnyumBlockEntity)) {
                throw new GameTestAssertException("Missing Entropinnyum at: " + POSITION_ENTROPINNYUM);
            }
            EntropinnyumBlockEntity entropinnyum = (EntropinnyumBlockEntity)be;
            if (entropinnyum.getMana() != 3) {
                throw new GameTestAssertException("Wrong amount of mana: expected 3 but was " + entropinnyum.getMana());
            }
        };
    }

    @GameTest(template="botania:block/entropinnyum_unethical_slime_duper_force_lens", timeoutTicks=150)
    public void testForceLensDuper(GameTestHelper helper) {
        helper.m_177425_().m_177562_(() -> {
            Player player = helper.m_177368_();
            ManaSpreaderBlockEntity spreader = TestingUtil.assertBlockEntity(helper, POSITION_FORCE_LENS_MANA_SPREADER, BotaniaBlockEntities.SPREADER);
            TestingUtil.assertThat(spreader.bindTo(player, new ItemStack((ItemLike)BotaniaItems.twigWand), helper.m_177449_(POSITION_FORCE_LENS_PUSHED_SLIME_BLOCK), Direction.UP), () -> "Failed to bind spreader");
            if (helper.m_177232_(POSITION_FORCE_LENS_DETECTOR_RAIL).m_60734_() != Blocks.f_50031_) {
                throw new GameTestAssertException("Missing detector rail at: " + POSITION_FORCE_LENS_DETECTOR_RAIL);
            }
            helper.m_177176_(EntityType.f_20469_, POSITION_FORCE_LENS_DETECTOR_RAIL);
            helper.m_177385_(POSITION_FORCE_LENS_BUTTON);
        }).m_177546_(130, EntropinnyumUnethicalTntDetectionTest.checkEntropinnyumForUnethicalManaAmount(helper)).m_177543_();
    }

    @GameTest(template="botania:block/entropinnyum_unethical_slime_duper_force_relay")
    public void testForceRelayDuper(GameTestHelper helper) {
        helper.m_177425_().m_177562_(() -> {
            if (helper.m_177232_(POSITION_FORCE_RELAY).m_60734_() != BotaniaBlocks.pistonRelay) {
                throw new GameTestAssertException("Missing force relay at: " + POSITION_FORCE_RELAY);
            }
            ForceRelayBlock.WorldData data = ForceRelayBlock.WorldData.get((Level)helper.m_177100_());
            data.mapping.put(helper.m_177449_(POSITION_FORCE_RELAY), helper.m_177449_(POSITION_FORCE_RELAY_PUSHED_SLIME_BLOCK));
            if (helper.m_177232_(POSITION_FORCE_RELAY_DETECTOR_RAIL).m_60734_() != Blocks.f_50031_) {
                throw new GameTestAssertException("Missing detector rail at: " + POSITION_FORCE_RELAY_DETECTOR_RAIL);
            }
            helper.m_177176_(EntityType.f_20469_, POSITION_FORCE_RELAY_DETECTOR_RAIL);
        }).m_177546_(1, () -> helper.m_177385_(POSITION_FORCE_RELAY_BUTTON)).m_177546_(90, EntropinnyumUnethicalTntDetectionTest.checkEntropinnyumForUnethicalManaAmount(helper)).m_177543_();
    }

    @GameTest(template="botania:block/entropinnyum_unethical_entityless_duper")
    public void testEntitylessDuper(GameTestHelper helper) {
        helper.m_177425_().m_177562_(() -> helper.m_177385_(POSITION_ENTITYLESS_DUPER_BUTTON)).m_177546_(95, EntropinnyumUnethicalTntDetectionTest.checkEntropinnyumForUnethicalManaAmount(helper)).m_177543_();
    }

    @GameTest(template="botania:block/entropinnyum_ethical_tnt_block")
    public void testLegitimateTnt(GameTestHelper helper) {
        helper.m_177425_().m_177562_(() -> helper.m_177385_(POSITION_ETHICAL_TNT_BLOCK_BUTTON)).m_177546_(95, () -> {
            BlockEntity be = helper.m_177347_(POSITION_ENTROPINNYUM);
            if (!(be instanceof EntropinnyumBlockEntity)) {
                throw new GameTestAssertException("Missing Entropinnyum at: " + POSITION_ENTROPINNYUM);
            }
            EntropinnyumBlockEntity entropinnyum = (EntropinnyumBlockEntity)be;
            if (entropinnyum.getMana() != entropinnyum.getMaxMana()) {
                throw new GameTestAssertException("Wrong amount of mana: expected " + entropinnyum.getMaxMana() + " but was " + entropinnyum.getMana());
            }
        }).m_177543_();
    }
}

