/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.configuration;

import net.minecraftforge.common.ForgeConfigSpec;

public class ConfigServerConfiguration {
    public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec SPEC;
    public static final ForgeConfigSpec.ConfigValue<Double> INFRASTRUCTURE_CHECK_RADIUS;
    public static final ForgeConfigSpec.ConfigValue<Double> NODE_DISTANCE_MINIMUM;
    public static final ForgeConfigSpec.ConfigValue<Double> NODE_DISTANCE_MAXIMUM;
    public static final ForgeConfigSpec.ConfigValue<Double> PATH_QUALITY_THRESHOLD;
    public static final ForgeConfigSpec.ConfigValue<Double> PATH_DISTANCE_MINIMUM;
    public static final ForgeConfigSpec.ConfigValue<Double> PATH_DISTANCE_MAXIMUM;
    public static final ForgeConfigSpec.ConfigValue<Double> TRAVEL_FATIGUE_COOLDOWN;
    public static final ForgeConfigSpec.ConfigValue<String> VALID_BLOCK_TAGS;
    public static final ForgeConfigSpec.ConfigValue<String> VALID_ENTITIES;
    public static final ForgeConfigSpec.ConfigValue<String> VALID_DIMENSIONS;
    public static final ForgeConfigSpec.ConfigValue<Boolean> DEBUG_MODE;
    public static final ForgeConfigSpec.ConfigValue<Double> PARTICLE_AMOUNT;
    public static final ForgeConfigSpec.ConfigValue<Boolean> SIGN_MESSAGE;

    static {
        BUILDER.push("Variables");
        INFRASTRUCTURE_CHECK_RADIUS = BUILDER.comment("Radius of region checked for path (ie. radius = x; checks ((x*2)+1)^3 cubic region)").define("Infrastructure Check Radius", (Object)1.0);
        NODE_DISTANCE_MINIMUM = BUILDER.comment("Minimum distance between two nodes").define("Node Distance Minimum", (Object)10.0);
        NODE_DISTANCE_MAXIMUM = BUILDER.comment("Maximum distance between two nodes").define("Node Distance Maximum", (Object)20.0);
        PATH_QUALITY_THRESHOLD = BUILDER.comment("% of blocks required to be path blocks in a 3x3 region of ground.").define("Path Quality Threshold", (Object)0.6);
        PATH_DISTANCE_MINIMUM = BUILDER.comment("The minimum length for a path to be valid in blocks from start to finish").define("Minimum Path Distance", (Object)50.0);
        PATH_DISTANCE_MAXIMUM = BUILDER.comment("The maximum length for a path to be valid in blocks from start to finish").define("Maximum Path Distance", (Object)100000.0);
        TRAVEL_FATIGUE_COOLDOWN = BUILDER.comment("Amount of ticks for teleport cooldown effect (enter 0 to disable)").define("Teleport Cooldown", (Object)60.0);
        BUILDER.pop();
        BUILDER.push("Allowed Blocks, Entities, & Dimensions");
        VALID_BLOCK_TAGS = BUILDER.comment("A comma seperated list of accepted path tags").define("Valid Block Tags", (Object)"forge:via_romana_path_block");
        VALID_ENTITIES = BUILDER.comment("Entities that you are able to teleport with").define("Valid Entities", (Object)"minecraft:player, minecraft:boat, minecraft:horse, minecraft:pig, minecraft:strider, minecraft:camel");
        VALID_DIMENSIONS = BUILDER.comment("Dimensions that paths will be allowed in").define("Valid Dimensions", (Object)"minecraft:overworld, minecraft:the_end");
        BUILDER.pop();
        BUILDER.push("Client");
        DEBUG_MODE = BUILDER.comment("Toggle debug overlay").define("Debug Mode", false);
        PARTICLE_AMOUNT = BUILDER.comment("The amount of particles generated per-tick for the teleport effect").define("Particle Amount", (Object)20.0);
        SIGN_MESSAGE = BUILDER.comment("Allow for teleport pop-up when looking at a linked sign").define("Linked Sign Message", false);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

